/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.InstanceUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyList
implements Cloneable {
    public static final String CLASS_PROPERTY_LIST = "Property_List";
    public static final String CLASS_WIDGET_DESCRIPTOR = "Widget";
    public static final String CLASS_STRING = "String";
    public static final String CLASS_INTEGER = "Integer";
    public static final String CLASS_BOOLEAN = "Boolean";
    public static final String CLASS_RECTANGLE = "Rectangle";
    public static final String SLOT_NAME = "name";
    public static final String SLOT_BOOLEAN_VALUE = "boolean_value";
    public static final String SLOT_INTEGER_VALUE = "integer_value";
    public static final String SLOT_STRING_VALUE = "string_value";
    public static final String SLOT_PROPERTIES = "properties";
    private Map<String, Slot> nameToSlotMap = new HashMap<String, Slot>();
    private Instance _instance;

    public PropertyList(Instance instance) {
        Assert.assertNotNull("instance", instance);
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_PROPERTY_LIST);
        this._instance = instance;
    }

    private void addProperty(Instance property) {
        Assert.assertNotNull("property", property);
        this.addValue(SLOT_PROPERTIES, property);
    }

    public void clear() {
        KnowledgeBase kb = this._instance.getKnowledgeBase();
        Collection values = this.getValues(SLOT_PROPERTIES);
        for (Instance instance : kb.getReachableSimpleInstances(values)) {
            kb.deleteInstance(instance);
        }
        this.setValue(SLOT_PROPERTIES, null);
    }

    public Object clone() {
        Instance instance = (Instance)this._instance.deepCopy(null, null);
        return new PropertyList(instance);
    }

    public static PropertyList create(KnowledgeBase kb) {
        Cls cls = kb.getCls(CLASS_PROPERTY_LIST);
        Instance instance = kb.createInstance(null, cls);
        return new PropertyList(instance);
    }

    private Instance createInstance(String clsName) {
        KnowledgeBase kb = this._instance.getKnowledgeBase();
        Cls cls = kb.getCls(clsName);
        return kb.createInstance(null, cls);
    }

    private Instance createProperty(String name, String propertyClsName) {
        Instance property = this.createInstance(propertyClsName);
        this.setValue(property, SLOT_NAME, name);
        this.addProperty(property);
        return property;
    }

    public WidgetDescriptor createWidgetDescriptor(String name) {
        Instance instance = this.getOrCreateProperty(name, CLASS_WIDGET_DESCRIPTOR);
        WidgetDescriptor desc = WidgetDescriptor.create(instance);
        return desc;
    }

    public Boolean getBoolean(String name) {
        Instance property = this.getProperty(name);
        return property == null ? (Boolean)null : (Boolean)this.getValue(property, SLOT_BOOLEAN_VALUE);
    }

    public Dimension getDimension(String name) {
        Instance instance = this.getProperty(name);
        return instance == null ? (Dimension)null : InstanceUtilities.getDimension(instance);
    }

    public Integer getInteger(String name) {
        Instance property = this.getProperty(name);
        return property == null ? (Integer)null : (Integer)this.getValue(property, SLOT_INTEGER_VALUE);
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._instance.getKnowledgeBase();
    }

    public Collection getNames() {
        ArrayList<Object> names = new ArrayList<Object>();
        for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
            names.add(this.getValue(instance, SLOT_NAME));
        }
        return names;
    }

    public Collection getLiveWidgetDescriptors() {
        ArrayList<WidgetDescriptor> widgetDescriptors = new ArrayList<WidgetDescriptor>();
        for (Instance property : this.getValues(SLOT_PROPERTIES)) {
            if (!WidgetDescriptor.isActiveWidget(property)) continue;
            WidgetDescriptor d = WidgetDescriptor.create(property);
            widgetDescriptors.add(d);
        }
        return widgetDescriptors;
    }

    private Instance getOrCreateProperty(String propertyName, String propertyClsName) {
        Instance property = this.getProperty(propertyName);
        if (property == null) {
            property = this.createProperty(propertyName, propertyClsName);
        } else if (!property.getDirectType().getName().equals(propertyClsName)) {
            property = this.replaceProperty(propertyName, property, propertyClsName);
        }
        return property;
    }

    private Instance getProperty(String name) {
        Instance property = null;
        if (name != null) {
            for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
                String propertyName = (String)this.getValue(instance, SLOT_NAME);
                if (!name.equals(propertyName)) continue;
                property = instance;
                break;
            }
        }
        return property;
    }

    public PropertyList getPropertyList(String name) {
        Instance instance = this.getOrCreateProperty(name, CLASS_PROPERTY_LIST);
        return new PropertyList(instance);
    }

    public Rectangle getRectangle(String name) {
        Instance instance = this.getProperty(name);
        return instance == null ? (Rectangle)null : InstanceUtilities.getRectangle(instance);
    }

    public String getString(String name) {
        Instance property = this.getProperty(name);
        return property == null ? (String)null : (String)this.getValue(property, SLOT_STRING_VALUE);
    }

    private Collection getValues(String name) {
        return this.getValues(this._instance, name);
    }

    public WidgetDescriptor getWidgetDescriptor(String name) {
        Instance instance = this.getProperty(name);
        WidgetDescriptor d = instance == null ? null : WidgetDescriptor.create(instance);
        return d;
    }

    public Instance getWrappedInstance() {
        return this._instance;
    }

    public void remove(String name) {
        Assert.assertNotNull(SLOT_NAME, name);
        for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
            String slotName = (String)this.getValue(instance, SLOT_NAME);
            if (!name.equals(slotName)) continue;
            this.removeValue(SLOT_PROPERTIES, instance);
            break;
        }
    }

    private void removeProperty(Instance property) {
        Assert.assertNotNull("property", property);
        this.removeValue(SLOT_PROPERTIES, property);
    }

    private void replaceProperty(Instance instance) {
        String name = (String)this.getValue(instance, SLOT_NAME);
        if (this.getProperty(name) != null) {
            this.remove(name);
        }
        this.addProperty(instance);
    }

    private Instance replaceProperty(String name, Instance property, String propertyClsName) {
        this.removeProperty(property);
        Instance result = this.createProperty(name, propertyClsName);
        return result;
    }

    public void setBoolean(String name, Boolean b) {
        this.setProperty(name, CLASS_BOOLEAN, SLOT_BOOLEAN_VALUE, b);
    }

    public void setBoolean(String name, boolean b) {
        this.setProperty(name, CLASS_BOOLEAN, SLOT_BOOLEAN_VALUE, b);
    }

    public void setInteger(String name, int i) {
        this.setProperty(name, CLASS_INTEGER, SLOT_INTEGER_VALUE, new Integer(i));
    }

    public void setInteger(String name, Integer i) {
        this.setProperty(name, CLASS_INTEGER, SLOT_INTEGER_VALUE, i);
    }

    private void setProperty(String name, String className, String slotName, Object value) {
        Instance property = this.getOrCreateProperty(name, className);
        this.setValue(property, slotName, value);
    }

    public void setRectangle(String name, Rectangle r) {
        Instance property = this.getOrCreateProperty(name, CLASS_RECTANGLE);
        InstanceUtilities.setRectangle(property, r);
    }

    public void setString(String name, String value) {
        this.setProperty(name, CLASS_STRING, SLOT_STRING_VALUE, value);
    }

    private void setValue(String slotName, Object value) {
        this.setValue(this._instance, slotName, value);
    }

    public void setWidgetDescriptor(WidgetDescriptor d) {
        this.replaceProperty(d.getInstance());
    }

    public String toString() {
        String s = CollectionUtilities.toString(this.getNames());
        return "PropertyList(" + s + ")";
    }

    private Slot getSlot(String name) {
        Slot slot = this.nameToSlotMap.get(name);
        if (slot == null) {
            slot = this._instance.getKnowledgeBase().getSlot(name);
            this.nameToSlotMap.put(name, slot);
        }
        return slot;
    }

    private void addValue(String slotName, Object value) {
        this._instance.addOwnSlotValue(this.getSlot(slotName), value);
    }

    private void removeValue(String slotName, Object value) {
        this._instance.removeOwnSlotValue(this.getSlot(slotName), value);
    }

    private Collection getValues(Instance instance, String slotName) {
        return instance.getDirectOwnSlotValues(this.getSlot(slotName));
    }

    private Object getValue(Instance instance, String slotName) {
        return instance.getDirectOwnSlotValue(this.getSlot(slotName));
    }

    private void setValue(Instance instance, String slotName, Object value) {
        instance.setDirectOwnSlotValue(this.getSlot(slotName), value);
    }
}

