/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MultiplexingClassLoader;
import edu.stanford.smi.protege.util.RemoteJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProtegeJob
extends RemoteJob
implements Localizable,
Serializable {
    private static final long serialVersionUID = -3178401391384077767L;
    private static transient Logger log = Log.getLogger(ProtegeJob.class);
    private transient KnowledgeBase kb;
    private transient RemoteClientFrameStore clientFrameStore = null;

    public ProtegeJob(KnowledgeBase kb) {
        this.kb = kb;
        DefaultKnowledgeBase dkb = (DefaultKnowledgeBase)kb;
        FrameStore terminalFrameStore = dkb.getTerminalFrameStore();
        if (terminalFrameStore instanceof RemoteClientFrameStore) {
            this.clientFrameStore = (RemoteClientFrameStore)terminalFrameStore;
        }
    }

    public Object execute() throws ProtegeException {
        if (this.clientFrameStore == null) {
            return this.run();
        }
        return this.clientFrameStore.executeProtegeJob(this);
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public void fixLoader() {
        ClassLoader correctLoader;
        ClassLoader kbLoader;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader jobLoader = this.getClass().getClassLoader();
        if (jobLoader == (kbLoader = this.kb.getClass().getClassLoader())) {
            correctLoader = jobLoader;
        } else {
            ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
            loaders.add(kbLoader);
            loaders.add(jobLoader);
            correctLoader = new MultiplexingClassLoader(loaders);
        }
        if (currentLoader != correctLoader) {
            if (log.isLoggable(Level.FINEST)) {
                Log.getLogger().finest("Changing loader from " + currentLoader + " to " + correctLoader);
            }
            Thread.currentThread().setContextClassLoader(correctLoader);
        }
    }

    public ProjectInstance getMetaProjectInstance() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        ServerProject serverProject = Server.getInstance().getServerProject(this.getKnowledgeBase().getProject());
        ServerFrameStore serverFs = (ServerFrameStore)serverProject.getDomainKbFrameStore(session);
        return serverFs.getMetaProjectInstance();
    }

    public boolean serverSideCheckOperationAllowed(Operation op) {
        return this.serverSideCheckOperationAllowed(op, this.getMetaProjectInstance());
    }

    public void localize(KnowledgeBase kb) {
        this.kb = kb;
    }
}

