/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class RemoveAction
extends AllowableAction {
    private static final long serialVersionUID = -5762542587316652756L;

    protected RemoveAction(ResourceKey key, Selectable selectable) {
        super(key, selectable);
    }

    protected RemoveAction(String text, Selectable selectable) {
        this(text, selectable, Icons.getRemoveIcon());
    }

    protected RemoveAction(String text, Selectable selectable, Icon icon) {
        this("Remove", text, selectable, icon);
    }

    protected RemoveAction(String name, String text, Selectable selectable, Icon icon) {
        super(name, text, icon, selectable);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.isAllowed() && this.confirmRemove()) {
            this.onRemove();
        }
    }

    private boolean confirmRemove() {
        boolean result;
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        if (project != null && project.getDisplayConfirmationOnRemove()) {
            String text = LocalizedText.getText(ResourceKey.DIALOG_CONFIRM_REMOVE_TEXT);
            int choice = ModalDialog.showMessageDialog((Component)((JComponent)((Object)this.getSelectable())), text, 13);
            result = choice == 2;
        } else {
            result = true;
        }
        return result;
    }

    public void onRemove(Collection objects) {
        for (Object o : objects) {
            this.onRemove(o);
        }
    }

    public void onRemove(Object o) {
        Log.getLogger().warning("onRemove called: should have been overridden");
    }

    public final void onRemove() {
        ArrayList objects = new ArrayList(this.getSelection());
        this.onRemove(objects);
    }
}

