/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.util.Collection;
import javax.swing.JComponent;

public class SelectableContainer
extends JComponent
implements Selectable,
Disposable {
    private static final long serialVersionUID = -3442680055824459200L;
    private ListenerCollection _listeners = new ListenerList(new SelectionEventDispatcher());
    private Selectable _selectable;
    private SelectionListener _selectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent event) {
            SelectableContainer.this.onSelectionChange();
            SelectableContainer.this.notifySelectionListeners();
        }
    };

    public SelectableContainer() {
        this.setLayout(new BorderLayout());
    }

    public SelectableContainer(Selectable s) {
        this();
        this.addSelectable(s);
    }

    private void addSelectable(Selectable selectable) {
        this._selectable = selectable;
        if (this._selectable != null) {
            this._selectable.addSelectionListener(this._selectionListener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this._listeners.add(this, listener);
    }

    public void clearSelection() {
        this._selectable.clearSelection();
    }

    public void dispose() {
        this.removeSelectable();
    }

    public Selectable getSelectable() {
        return this._selectable;
    }

    public Collection getSelection() {
        return this._selectable == null ? null : this._selectable.getSelection();
    }

    public Object getSoleSelection() {
        Object soleSelection = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            soleSelection = CollectionUtilities.getFirstItem(selection);
        }
        return soleSelection;
    }

    public void notifySelectionListeners() {
        this._listeners.postEvent(this, 1);
    }

    public void onSelectionChange() {
    }

    private void removeSelectable() {
        if (this._selectable != null) {
            this._selectable.removeSelectionListener(this._selectionListener);
        }
        this._selectable = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this._listeners.remove(this, listener);
    }

    public boolean setNotificationsEnabled(boolean b) {
        return this._listeners.setPostingEnabled(b);
    }

    public void setSelectable(Selectable s) {
        this.removeSelectable();
        this.addSelectable(s);
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

