/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectableList
extends JList
implements Selectable {
    private static final long serialVersionUID = -5479458103259963384L;
    private ListenerCollection _listeners = new ListenerList(new SelectionEventDispatcher());
    private boolean _isDragEvent;
    private boolean _isMultiSelectPressEvent;
    private boolean _isDeferringSelection;

    public SelectableList() {
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    SelectableList.this.notifySelectionListeners();
                }
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this._listeners.add(this, listener);
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this);
    }

    public void setSelectedValue(Object value) {
        ComponentUtilities.setSelectedValue(this, value);
    }

    public void setListenerNotificationEnabled(boolean enabled) {
        this._listeners.setPostingEnabled(enabled);
    }

    public void notifySelectionListeners() {
        this._listeners.postEvent(this, 1);
    }

    public void processMouseEvent(MouseEvent event) {
        this._isMultiSelectPressEvent = false;
        int index = this.locationToIndex(event.getPoint());
        int id = event.getID();
        if (id == 501) {
            if (index == -1) {
                this.clearSelection();
            } else if (this.isSelectedIndex(index)) {
                this._isMultiSelectPressEvent = true;
                if (!event.isPopupTrigger()) {
                    this._isDeferringSelection = true;
                }
            }
        }
        if (this._isDeferringSelection && id == 502) {
            this.setSelectionInterval(index, index);
            this._isDeferringSelection = false;
        }
        super.processMouseEvent(event);
        this._isMultiSelectPressEvent = false;
    }

    public void processMouseMotionEvent(MouseEvent event) {
        boolean dragDropEnabled = ComponentUtilities.isDragAndDropEnabled(this);
        this._isDragEvent = dragDropEnabled && event.getID() == 506;
        super.processMouseMotionEvent(event);
        this._isDragEvent = false;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this._listeners.remove(this, listener);
    }

    public void setSelectionInterval(int r1, int r2) {
        if (!this._isDragEvent && !this._isMultiSelectPressEvent) {
            super.setSelectionInterval(r1, r2);
        }
    }

    public String toString() {
        return "SelectableList";
    }
}

