/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.LookAndFeelUtil;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.TreeSelectionListenerAdapter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class SelectableTree
extends JTree
implements Selectable,
Disposable,
Autoscroll {
    private static final long serialVersionUID = -97980195042663048L;
    private ListenerCollection _selectionListeners = new ListenerList(new SelectionEventDispatcher());
    private static final int SCROLL_BORDER = 8;
    private TreeModelListener listener = new TreeModelListener(){

        public void treeNodesInserted(TreeModelEvent event) {
            SelectableTree.this.expandRow(0);
        }

        public void treeNodesChanged(TreeModelEvent event) {
        }

        public void treeNodesRemoved(TreeModelEvent event) {
        }

        public void treeStructureChanged(TreeModelEvent event) {
        }
    };

    public SelectableTree(Action doubleClickAction) {
        this(doubleClickAction, null);
    }

    public SelectableTree(Action doubleClickAction, LazyTreeRoot root) {
        super(new LazyTreeModel(root));
        ComponentFactory.configureTree(this, doubleClickAction);
        this.getModel().addTreeModelListener(this.listener);
        this.expandRow(0);
        this.addMouseListener(new TreePopupMenuMouseListener(this){

            public JPopupMenu getPopupMenu() {
                return SelectableTree.this.getPopupMenu();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListenerAdapter(this));
        try {
            LookAndFeelUtil.setTreeLineStyle(this);
        }
        catch (Throwable e) {
            Log.emptyCatchBlock(e);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.add(this, selectionListener);
    }

    public void dispose() {
        TreeModel model = this.getModel();
        if (model != null) {
            model.removeTreeModelListener(this.listener);
            if (model instanceof LazyTreeModel) {
                LazyTreeModel lazyModel = (LazyTreeModel)model;
                lazyModel.dispose();
            }
        }
        this.setCellRenderer(null);
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this);
    }

    public void notifySelectionListeners() {
        this._selectionListeners.postEvent(this, 1);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.remove(this, selectionListener);
    }

    public void setRoot(LazyTreeRoot root) {
        LazyTreeModel model = (LazyTreeModel)this.getModel();
        model.setRoot(root);
        this.expandRow(0);
    }

    public String toString() {
        return "SelectableTree";
    }

    public void processFocusEvent(FocusEvent event) {
        if (this.getParent() != null) {
            super.processFocusEvent(event);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRect();
        Dimension size = this.getSize();
        Insets insets = new Insets(r.y + 8, r.x + 8, size.height - r.y - r.height + 8, size.width - r.x - r.width + 8);
        return insets;
    }

    public void autoscroll(Point location) {
        JScrollPane scroller = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scroller != null) {
            JScrollBar hBar = scroller.getHorizontalScrollBar();
            JScrollBar vBar = scroller.getVerticalScrollBar();
            Rectangle r = this.getVisibleRect();
            if (location.x <= r.x + 8) {
                SelectableTree.scroll(hBar, -1);
            }
            if (location.y <= r.y + 8) {
                SelectableTree.scroll(vBar, -1);
            }
            if (location.x >= r.x + r.width - 8) {
                SelectableTree.scroll(hBar, 1);
            }
            if (location.y >= r.y + r.height - 8) {
                SelectableTree.scroll(vBar, 1);
            }
        }
    }

    private static void scroll(JScrollBar bar, int increment) {
        int sign = increment < 0 ? -1 : 1;
        bar.setValue(bar.getValue() + sign * bar.getUnitIncrement(increment));
    }
}

