/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class SimpleListModel
extends AbstractListModel {
    private static final long serialVersionUID = 4610768415608528873L;
    private List _list = this.makeList();

    public SimpleListModel() {
    }

    public SimpleListModel(Collection values) {
        this._list.addAll(values);
    }

    protected List makeList() {
        return new ArrayList();
    }

    protected List getList() {
        return this._list;
    }

    public int addValue(Object o) {
        int index = this._list.size();
        this._list.add(index, o);
        this.fireIntervalAdded(this, index, index);
        return index;
    }

    public void addValue(Object o, int index) {
        this._list.add(index, o);
        this.fireIntervalAdded(this, index, index);
    }

    public int addValues(Collection values) {
        int startIndex = this._list.size();
        int endIndex = startIndex + values.size();
        this._list.addAll(values);
        this.fireIntervalAdded(this, startIndex, endIndex);
        return startIndex;
    }

    public void clear() {
        if (!this._list.isEmpty()) {
            int index = this._list.size() - 1;
            this._list.clear();
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public boolean contains(Object o) {
        return this._list.contains(o);
    }

    public Object getElementAt(int i) {
        return i >= 0 && i < this._list.size() ? this._list.get(i) : null;
    }

    public int getSize() {
        return this._list.size();
    }

    public List getValues() {
        return Collections.unmodifiableList(this._list);
    }

    public int indexOf(Object o) {
        return this._list.indexOf(o);
    }

    public void moveValue(int start, int end) {
        if (start != end) {
            Object o = this._list.remove(start);
            if (end > start) {
                --end;
            }
            this._list.add(end, o);
            this.fireContentsChanged(this, start, end);
        }
    }

    public int removeValue(Object o) {
        int index = this._list.indexOf(o);
        if (index != -1) {
            this._list.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
        return index;
    }

    public int removeValues(Collection values) {
        int startIndex = -1;
        for (Object o : values) {
            if (startIndex == -1) {
                startIndex = this.indexOf(o);
            }
            this._list.remove(o);
        }
        this.fireIntervalRemoved(this, startIndex, startIndex);
        return startIndex;
    }

    public void setValue(int index, Object o) {
        this._list.set(index, o);
        this.fireContentsChanged(this, index, index);
    }

    public void setValues(Collection values) {
        this.clear();
        if (!values.isEmpty()) {
            this._list = new ArrayList(values);
            this.fireIntervalAdded(this, 0, values.size() - 1);
        }
    }

    public List toList() {
        return Collections.unmodifiableList(this._list);
    }

    public String toString() {
        return "SimpleListModel";
    }
}

