/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class StandardAction
extends AbstractAction {
    private static final long serialVersionUID = 3832046476795272130L;
    public static final String DISABLED_ICON = "DisabledSmallIcon";

    protected StandardAction(String name) {
        super(name);
    }

    protected StandardAction(String name, Icon icon) {
        super(name, icon);
    }

    protected StandardAction(ResourceKey key) {
        this(key, false);
    }

    protected StandardAction(ResourceKey key, boolean useLargeIcons) {
        StandardAction.initialize(this, key, useLargeIcons);
    }

    public void substituteIntoName(String text) {
        String name = this.getName();
        String newName = StringUtilities.replace(name, "{0}", text);
        this.setName(newName);
    }

    public static void initialize(Action action, ResourceKey key, boolean useLargeIcons) {
        StandardAction.setName(action, LocalizedText.getText(key));
        StandardAction.setIcon(action, Icons.lookupActionIcon(key, false, false));
        StandardAction.setShortcut(action, LocalizedText.getShortcut(key));
        StandardAction.setMnemonic(action, LocalizedText.getMnemonic(key));
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public String getName() {
        return StandardAction.getName(this);
    }

    public static String getName(Action action) {
        return (String)action.getValue("Name");
    }

    public void setName(String text) {
        StandardAction.setName(this, text);
    }

    public void setDescription(String text) {
        StandardAction.setDescription(this, text);
    }

    public static void setName(Action action, String text) {
        action.putValue("Name", text);
    }

    public static void setDescription(Action action, String text) {
        action.putValue("ShortDescription", text);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        StandardAction.setIcon(this, icon);
    }

    public static void setIcon(Action action, Icon icon) {
        action.putValue("SmallIcon", icon);
    }

    public void setDisabledIcon(Icon icon) {
        StandardAction.setDisabledIcon(this, icon);
    }

    public static void setDisabledIcon(Action action, Icon icon) {
        action.putValue(DISABLED_ICON, icon);
    }

    public void setShortcut(int c) {
        StandardAction.setShortcut(this, c);
    }

    public static void setShortcut(Action action, int c) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke stroke = c == 0 ? null : KeyStroke.getKeyStroke(c, mask);
        action.putValue("AcceleratorKey", stroke);
    }

    public void setMnemonic(int c) {
        StandardAction.setMnemonic(this, c);
    }

    public static void setMnemonic(Action action, int c) {
        Integer value = c == 0 ? null : new Integer(c);
        action.putValue("MnemonicKey", value);
    }
}

