/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.BrowserLauncher;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.LookAndFeelUtil;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class SystemUtilities {
    private static final Logger log = Log.getLogger(SystemUtilities.class);
    private static final String OLD_PLASTIC_LAF_NAME = "com.jgoodies.plaf.plastic.PlasticLookAndFeel";
    private static final String NEW_PLASTIC_LAF_NAME = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    private static boolean isMac;
    private static boolean isWindows;
    private static boolean isApplet;
    private static boolean useAntialiasing;

    public static void initialize() {
    }

    public static void initGraphics() {
        SystemUtilities.loadLookAndFeel();
    }

    public static void debugBreak() {
    }

    public static void exit() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Class forName(String className) {
        return PluginUtilities.forName(className);
    }

    public static Class forName(String className, boolean promiscuous) {
        return PluginUtilities.forName(className, promiscuous);
    }

    public static void gc() {
        System.gc();
        System.runFinalization();
        System.gc();
    }

    public static String getSystemProperty(String property) {
        String value;
        try {
            value = System.getProperty(property);
        }
        catch (SecurityException e) {
            value = null;
        }
        return value;
    }

    public static String getSystemProperty(String property, String defaultValue) {
        String value;
        try {
            value = System.getProperty(property, defaultValue);
        }
        catch (SecurityException e) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getSystemBooleanProperty(String property) {
        boolean value = false;
        try {
            value = Boolean.getBoolean(property);
        }
        catch (SecurityException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static boolean getSystemBooleanProperty(String property, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = Boolean.getBoolean(property);
        }
        catch (SecurityException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static int getSystemIntegerProperty(String property) {
        int value = 0;
        try {
            value = Integer.getInteger(property);
        }
        catch (SecurityException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static int getSystemIntegerProperty(String property, int defaultValue) {
        int value = defaultValue;
        try {
            Integer i = Integer.getInteger(property);
            if (i != null) {
                value = i;
            }
        }
        catch (SecurityException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static String getUserDirectory() {
        return SystemUtilities.getSystemProperty("user.dir");
    }

    public static String getLineSeparator() {
        return SystemUtilities.getSystemProperty("line.separator");
    }

    public static String getMachineName() {
        String machineName;
        try {
            machineName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            machineName = "Unknown";
        }
        return machineName;
    }

    public static String getMachineIpAddress() {
        String machineIpAddress;
        try {
            machineIpAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Log.getLogger().warning("Unable to determine ip address");
            machineIpAddress = "127.0.0.1";
        }
        return machineIpAddress;
    }

    public static String getFileEncoding() {
        return SystemUtilities.getSystemProperty("protege.file.encoding", "UTF-8");
    }

    public static String getUserName() {
        return SystemUtilities.getSystemProperty("user.name");
    }

    private static void init() {
        try {
            SystemUtilities.logSystemInfo();
            SystemUtilities.loadParameters();
            PluginUtilities.initialize();
            SystemUtilities.loadUseAntialiasing();
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
    }

    private static void loadParameters() {
        String osName = SystemUtilities.getSystemProperty("os.name");
        isMac = osName.indexOf("Mac") != -1;
        isWindows = osName.indexOf("Windows") != -1;
    }

    private static void loadLookAndFeel() {
        String lafName = ApplicationProperties.getLookAndFeelClassName();
        if (lafName.equals(OLD_PLASTIC_LAF_NAME)) {
            lafName = NEW_PLASTIC_LAF_NAME;
            ApplicationProperties.setLookAndFeel(lafName);
        }
        SystemUtilities.setLookAndFeel(lafName);
    }

    public static void setLookAndFeel(String lafName) {
        try {
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafName).newInstance();
            if (lafName.indexOf("Plastic") != -1) {
                LookAndFeelUtil.setUpPlasticLF();
            } else if (lafName.indexOf("Metal") != -1) {
                MetalLookAndFeel.setCurrentTheme(SystemUtilities.createDefaultMetalTheme());
            }
            UIManager.put("ClassLoader", lookAndFeel.getClass().getClassLoader());
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            Log.getLogger().warning("Look and feel not found: " + lafName);
        }
        catch (Exception e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean modalDialogInDropWorks() {
        return true;
    }

    public static Object newInstance(Class clas, Class[] argumentClasses, Object[] arguments) {
        Object instance = null;
        try {
            Constructor constructor = clas.getConstructor(argumentClasses);
            instance = constructor.newInstance(arguments);
        }
        catch (Throwable e) {
            Log.getLogger().warning(Log.toString(e));
        }
        return instance;
    }

    public static Object newInstance(String className) {
        Object o = null;
        try {
            Class clas = SystemUtilities.forName(className);
            if (clas == null) {
                Log.getLogger().warning("no such class: " + className);
            } else {
                o = clas.newInstance();
            }
        }
        catch (Throwable e) {
            Log.getLogger().warning(Log.toString(e));
        }
        return o;
    }

    public static Object newInstance(Class clas) {
        Object o = null;
        try {
            o = clas.newInstance();
        }
        catch (Throwable e) {
            Log.getLogger().warning(Log.toString(e));
        }
        return o;
    }

    public static void pause() {
        try {
            System.out.flush();
            System.err.flush();
            System.out.print("Press <Enter> to continue");
            System.in.read();
            while (System.in.available() != 0) {
                System.in.read();
            }
        }
        catch (Exception e) {
            Log.getLogger().warning(Log.toString(e));
        }
    }

    public static void printMemoryUsage() {
        SystemUtilities.gc();
        SystemUtilities.printMemoryUsageNoGC();
    }

    public static void printMemoryUsageNoGC() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        String s = "memory: total=" + total + ", used=" + (total - free);
        Log.getLogger().finest(s);
    }

    public static void logSystemInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Text.getProgramTextName());
        buffer.append(" ");
        buffer.append(Text.getVersion());
        buffer.append(" ");
        buffer.append(Text.getBuildInfo());
        buffer.append(", JVM ");
        buffer.append(SystemUtilities.getSystemProperty("java.runtime.version"));
        buffer.append(", memory=");
        buffer.append(Runtime.getRuntime().maxMemory() / 1000000L);
        buffer.append("M, ");
        buffer.append(SystemUtilities.getSystemProperty("os.name"));
        buffer.append(", encoding=");
        buffer.append(SystemUtilities.getFileEncoding());
        buffer.append(", language=");
        buffer.append(Locale.getDefault().getLanguage());
        buffer.append(", country=");
        buffer.append(Locale.getDefault().getCountry());
        Log.getLogger().config(buffer.toString());
    }

    public static void printSystemProperties(PrintStream stream) {
        stream.println("System Properties:");
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(System.getProperties().entrySet());
        Collections.sort(entries, new PropertyComparator());
        for (Map.Entry entry : entries) {
            String key = entry.getKey().toString();
            if (key.startsWith("lax.")) continue;
            stream.println("\t" + key + "=" + entry.getValue());
        }
    }

    public static void showHTML(String url) {
        try {
            if (!(url.startsWith("http:") || url.startsWith("file:") || url.startsWith("mailto:"))) {
                url = new File(url).toURI().toURL().toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("showHTML " + url);
            }
            BrowserLauncher.openURL(url);
        }
        catch (IOException e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public static void sleepMsec(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (Exception e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public static Boolean toBoolean(Object o) {
        String s;
        Boolean b = o instanceof Boolean ? (Boolean)o : ((s = o.toString()).equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : null));
        return b;
    }

    public static Float toFloat(Object o) {
        Float f;
        if (o instanceof Float) {
            f = (Float)o;
        } else {
            try {
                f = Float.valueOf(o.toString());
            }
            catch (Exception e) {
                f = null;
            }
        }
        return f;
    }

    public static Integer toInteger(Object o) {
        Integer i;
        if (o instanceof Integer) {
            i = (Integer)o;
        } else {
            try {
                i = Integer.valueOf(o.toString());
            }
            catch (Exception e) {
                i = null;
            }
        }
        return i;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static Collection getClassesWithAttribute(String key, String value) {
        return PluginUtilities.getClassesWithAttribute(key, value);
    }

    public static void setContextClassLoader(Object o) {
        try {
            Thread.currentThread().setContextClassLoader(o.getClass().getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean showAlphaFeatures() {
        boolean showAlpha = false;
        String showAlphaString = SystemUtilities.getSystemProperty("protege.alpha");
        if (showAlphaString != null) {
            showAlpha = Boolean.valueOf(showAlphaString);
        }
        return showAlpha;
    }

    public static boolean useAntialiasing() {
        return useAntialiasing;
    }

    private static void loadUseAntialiasing() {
        String property = ApplicationProperties.getApplicationOrSystemProperty("antialiasing.enable");
        useAntialiasing = property == null ? UIManager.getLookAndFeel().getClass().getName().indexOf("Plastic") != -1 && !SystemUtilities.isMac() : Boolean.valueOf(property);
    }

    private static MetalTheme createDefaultMetalTheme() {
        MetalTheme theme = SystemUtilities.isJDK15() ? (MetalTheme)SystemUtilities.newInstance("javax.swing.plaf.metal.OceanTheme") : new DefaultMetalTheme();
        return theme;
    }

    private static boolean isJDK15() {
        String property = SystemUtilities.getSystemProperty("java.runtime.version");
        return property.startsWith("1.5.");
    }

    public static Locale getSystemLocale() {
        String country = System.getProperty("user.country");
        String language = System.getProperty("user.language");
        return new Locale(language, country);
    }

    public static Locale getProtegeSystemDefaultLocale() {
        return new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void setApplet(boolean b) {
        isApplet = b;
    }

    static {
        SystemUtilities.init();
    }

    private static class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            Map.Entry entry1 = (Map.Entry)o1;
            Map.Entry entry2 = (Map.Entry)o2;
            return entry1.getKey().toString().compareToIgnoreCase(entry2.getKey().toString());
        }
    }
}

