/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TransferableCollection
implements Transferable {
    private static final Collection flavors = new ArrayList();
    private static DataFlavor collectionFlavor;
    private ArrayList frames;

    public TransferableCollection(Collection frames) {
        this.frames = new ArrayList(frames);
    }

    public static DataFlavor getCollectionFlavor() {
        return collectionFlavor;
    }

    public Object getTransferData(DataFlavor flavor) {
        Object o = flavor.equals(collectionFlavor) ? this.getCollectionTransferData() : (flavor.equals(DataFlavor.stringFlavor) ? this.getStringTransferData() : null);
        return o;
    }

    public Object getCollectionTransferData() {
        return new ArrayList(this.frames);
    }

    public Object getStringTransferData() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.frames.iterator();
        while (i.hasNext()) {
            Frame frame = (Frame)i.next();
            String name = frame.getName();
            buffer.append(name);
            if (!i.hasNext()) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavors.contains(flavor);
    }

    static {
        try {
            String collectionClassname = ArrayList.class.getName();
            String collectionFlavorName = "application/x-java-jvm-local-objectref; class=" + collectionClassname;
            collectionFlavor = new DataFlavor(collectionFlavorName);
            flavors.add(collectionFlavor);
            flavors.add(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            Log.getLogger().warning(Log.toString(e));
        }
    }
}

