/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<X>
implements Cloneable {
    private X root;
    private Map<X, Set<X>> nodeToChildrenMap = new LinkedHashMap<X, Set<X>>();

    public Tree(X root) {
        this.setRoot(root);
    }

    public Tree() {
    }

    public Tree<X> clone() {
        Tree<X> tree = new Tree<X>(this.root);
        for (Map.Entry<X, Set<X>> entry : this.nodeToChildrenMap.entrySet()) {
            X node = entry.getKey();
            Set<X> children = entry.getValue();
            tree.nodeToChildrenMap.put(node, new LinkedHashSet<X>(children));
        }
        return tree;
    }

    public void setRoot(X root) {
        this.root = root;
    }

    public void swapNode(X oldNode, X newNode) {
        Set<X> children;
        if (this.root == oldNode) {
            this.root = newNode;
        }
        if ((children = this.nodeToChildrenMap.remove(oldNode)) != null) {
            this.nodeToChildrenMap.put(newNode, children);
        }
        for (Set<X> nodeChildren : this.nodeToChildrenMap.values()) {
            boolean succeeded = nodeChildren.remove(oldNode);
            if (!succeeded) continue;
            nodeChildren.add(newNode);
        }
    }

    public X getRoot() {
        return this.root;
    }

    public boolean isReachable(X node) {
        return this.root == node || this.getDescendents(this.root).contains(node);
    }

    public void addChild(X parent, X child) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        Set<X> children = this.nodeToChildrenMap.get(parent);
        if (children == null) {
            children = new LinkedHashSet<X>();
            this.nodeToChildrenMap.put(parent, children);
        }
        children.add(child);
    }

    public void removeChild(X parent, X child) {
        Set<X> children = this.nodeToChildrenMap.get(parent);
        if (children == null) {
            Tree.logNoSuchChild(parent, child);
        } else {
            boolean succeeded = children.remove(child);
            if (!succeeded) {
                Tree.logNoSuchChild(parent, child);
            }
        }
    }

    public void removeNode(X node) {
        if (this.root == node) {
            this.root = null;
        }
        this.nodeToChildrenMap.remove(node);
        for (Set<X> children : this.nodeToChildrenMap.values()) {
            children.remove(node);
        }
    }

    private static void logNoSuchChild(Object parent, Object child) {
        Log.getLogger().warning("No such child: " + parent + " " + child);
    }

    public Set<X> getChildren(X parent) {
        Set<X> children = this.nodeToChildrenMap.get(parent);
        return children == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(children);
    }

    public Set<X> getNodeAndDescendents(X parent) {
        Set<X> descendents = this.getDescendents(parent);
        if (parent == null) {
            Log.getLogger().severe("Null parent");
        } else {
            descendents.add(parent);
        }
        return descendents;
    }

    public Set<X> getDescendents(X parent) {
        LinkedHashSet descendents = new LinkedHashSet();
        this.getDescendents(parent, descendents);
        return descendents;
    }

    private void getDescendents(X parent, Set<X> descendents) {
        Set<X> children = this.nodeToChildrenMap.get(parent);
        if (children != null) {
            for (X o : children) {
                boolean changed = descendents.add(o);
                if (!changed) continue;
                this.getDescendents(o, descendents);
            }
        }
    }

    public Set<X> getNodes() {
        return this.getDescendents(this.root);
    }
}

