/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protege.util.TreeTarget;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class TreeDragSourceListener
implements DragGestureListener,
DragSourceListener {
    private Collection _paths;

    public abstract boolean canStartDrag(Collection var1);

    public abstract void doCopy(Collection var1);

    public abstract void doMove(Collection var1);

    public void dragDropEnd(DragSourceDropEvent e) {
        if (TreeDragSourceListener.dropSucceeded(e)) {
            int action = e.getDropAction();
            if (action == 2) {
                this.doMove(this._paths);
            } else if (action == 1) {
                this.doCopy(this._paths);
            }
        }
    }

    private static boolean dropSucceeded(DragSourceDropEvent e) {
        boolean succeeded = SystemUtilities.isMac() ? TreeTarget.getLastDropSucceeded() : e.getDropSuccess();
        return succeeded;
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        JTree tree = (JTree)e.getComponent();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        this._paths = selectionPaths == null ? Collections.EMPTY_LIST : Arrays.asList(selectionPaths);
        Collection objects = ComponentUtilities.getSelection(tree);
        if (objects != null && this.canStartDrag(objects)) {
            TransferableCollection t = new TransferableCollection(objects);
            e.startDrag(DragSource.DefaultMoveDrop, t, this);
        }
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }
}

