/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WaitCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeSelectionHelper<X> {
    private JTree tree;

    public TreeSelectionHelper(JTree tree) {
        this.tree = tree;
    }

    protected abstract Collection<X> getParents(X var1);

    protected boolean isVisible(X element) {
        return true;
    }

    protected Collection<X> getRoots() {
        ArrayList roots = new ArrayList((Collection)((LazyTreeNode)this.tree.getModel().getRoot()).getUserObject());
        return roots;
    }

    public void setSelectedNode(X value) {
        WaitCursor cursor = new WaitCursor(this.tree);
        ArrayList frames = new ArrayList();
        this.getVisiblePathToRoot(value, frames);
        Collections.reverse(frames);
        ComponentUtilities.setSelectedObjectPath(this.tree, frames);
        cursor.hide();
    }

    protected Collection<X> filterHiddenRoots(Collection<X> roots) {
        Iterator<X> i = roots.iterator();
        while (i.hasNext()) {
            X root = i.next();
            if (this.isVisible(root)) continue;
            i.remove();
        }
        return roots;
    }

    public void getVisiblePathToRoot(X elem, Collection<X> path) {
        boolean succeeded;
        Collection<X> roots = this.filterHiddenRoots(this.getRoots());
        path.add(elem);
        if (!roots.contains(elem) && !(succeeded = this.getVisiblePathToRoot(elem, roots, path))) {
            Log.getLogger().warning("No visible path found for " + elem);
        }
    }

    private boolean getVisiblePathToRoot(X elem, Collection<X> roots, Collection<X> path) {
        boolean found = false;
        Iterator<X> i = this.getParents(elem).iterator();
        while (i.hasNext() && !found) {
            X parent = i.next();
            if (!this.isVisible(parent) || path.contains(parent)) continue;
            path.add(parent);
            found = roots.contains(parent) ? true : this.getVisiblePathToRoot(parent, roots, path);
            if (found) continue;
            path.remove(parent);
        }
        return found;
    }
}

