/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class TreeTarget
implements DropTargetListener {
    private int _dropSelectionRow;
    private Object _dropSelectionArea;
    private boolean _allowsBetweenDrops;
    private static boolean lastDropSucceeded;

    protected TreeTarget(boolean allowsBetweenDrops) {
        this._allowsBetweenDrops = allowsBetweenDrops;
    }

    private void clearDropSelection(JTree tree) {
        tree.putClientProperty(DefaultRenderer.DROP_TARGET, null);
        tree.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, null);
        this._dropSelectionRow = -1;
        this._dropSelectionArea = null;
        tree.repaint();
    }

    public abstract boolean doDrop(JTree var1, Object var2, int var3, Object var4);

    protected boolean doDrop(JTree tree, Collection sources, int row, Object area) {
        boolean succeeded = true;
        for (Object source : sources) {
            succeeded = this.doDrop(tree, source, this._dropSelectionRow, this._dropSelectionArea);
        }
        return succeeded;
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        this.clearDropSelection(TreeTarget.getTree(e));
    }

    public void dragOver(DropTargetDragEvent e) {
        this.setDropSelection(e);
    }

    public void drop(DropTargetDropEvent e) {
        boolean succeeded = false;
        DataFlavor flavor = TransferableCollection.getCollectionFlavor();
        JTree tree = TreeTarget.getTree(e);
        if (e.isDataFlavorSupported(flavor)) {
            try {
                int action = e.getDropAction();
                this.setDropSelection(TreeTarget.getTree(e), e.getLocation());
                if (this._dropSelectionRow != -1) {
                    Collection sources = (Collection)e.getTransferable().getTransferData(flavor);
                    succeeded = this.doDrop(tree, sources, this._dropSelectionRow, this._dropSelectionArea);
                }
                e.acceptDrop(action);
            }
            catch (Exception ex) {
                Log.getLogger().warning(Log.toString(ex));
            }
        } else {
            e.rejectDrop();
            Log.getLogger().warning("unsupported flavor: " + e);
        }
        lastDropSucceeded = succeeded;
        e.dropComplete(succeeded);
        this.clearDropSelection(tree);
    }

    public static boolean getLastDropSucceeded() {
        return lastDropSucceeded;
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private static JTree getTree(DropTargetDragEvent e) {
        return (JTree)e.getDropTargetContext().getComponent();
    }

    private static JTree getTree(DropTargetEvent e) {
        return (JTree)e.getDropTargetContext().getComponent();
    }

    private void setDropSelection(DropTargetDragEvent e) {
        this.setDropSelection(TreeTarget.getTree(e), e.getLocation());
    }

    private void setDropSelection(JTree tree, Point p) {
        this._dropSelectionRow = tree.getRowForLocation(p.x, p.y);
        if (this._dropSelectionRow == -1) {
            this.clearDropSelection(tree);
        } else {
            if (this._allowsBetweenDrops) {
                Rectangle r = tree.getRowBounds(this._dropSelectionRow);
                if (p.y < r.y + r.height / 4) {
                    if (this._dropSelectionRow == 0) {
                        this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
                    } else {
                        --this._dropSelectionRow;
                        this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_BELOW;
                    }
                } else {
                    this._dropSelectionArea = p.y < r.y + 3 * r.height / 4 ? DefaultRenderer.DROP_TARGET_AREA_ON : DefaultRenderer.DROP_TARGET_AREA_BELOW;
                }
            } else {
                this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_ON;
            }
            TreePath path = tree.getPathForRow(this._dropSelectionRow);
            LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
            tree.putClientProperty(DefaultRenderer.DROP_TARGET, node);
            tree.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, this._dropSelectionArea);
            tree.repaint();
            Thread.yield();
        }
    }
}

