/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class URIField
extends JComponent {
    private static final long serialVersionUID = -4728998781503944838L;
    private JTextField _textField;
    private String _description;
    private String _extension;
    private ChangeListener _changeListener;

    public URIField(String label, URI uri, String extension, String description) {
        this._description = description;
        this._extension = extension;
        this.setLayout(new BorderLayout());
        LabeledComponent c = new LabeledComponent(label, this.createComponent(uri));
        c.addHeaderButton(new AbstractAction("Browse for File", Icons.getAddIcon()){
            private static final long serialVersionUID = 1162670958348183368L;

            public void actionPerformed(ActionEvent event) {
                URIField.this.browse();
            }
        });
        this.add(c);
    }

    public void addChangeListener(ChangeListener listener) {
        Assert.assertNull("existing change listener", this._changeListener);
        this._changeListener = listener;
    }

    protected void browse() {
        JFileChooser chooser = ComponentFactory.createFileChooser(this._description, this._extension);
        chooser.setApproveButtonText("Select");
        int openDialogResult = chooser.showOpenDialog(this);
        switch (openDialogResult) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this._textField.setText(chooser.getSelectedFile().getPath());
                break;
            }
            default: {
                Assert.fail("bad result: " + openDialogResult);
            }
        }
    }

    private JComponent createComponent(URI uri) {
        this._textField = ComponentFactory.createTextField();
        this._textField.setColumns(40);
        this.setURI(uri);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent event) {
                URIField.this.notifyListener();
            }
        });
        return this._textField;
    }

    public URI getAbsoluteURI() {
        String text = this._textField.getText();
        return URIUtilities.createURI(text);
    }

    public URI getRelativeURI() {
        URI uri = null;
        String text = this._textField.getText().trim();
        if (text.length() > 0) {
            try {
                uri = new URI(text);
            }
            catch (Exception e) {
                File file = new File(text);
                try {
                    uri = new URI(file.getName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return uri;
    }

    private void notifyListener() {
        if (this._changeListener != null) {
            this._changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setURI(URI uri) {
        String text = uri == null ? null : uri.toString();
        this._textField.setText(text);
    }
}

