/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AbstractSelectableComponent;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;

public class URIList
extends AbstractSelectableComponent {
    private static final long serialVersionUID = 1611646775722808214L;
    private JList _uriList;
    private String _description;
    private String _extension;

    public URIList(String label, Collection uris, String extension, String description) {
        this._description = description;
        this._extension = extension;
        this.setLayout(new BorderLayout());
        LabeledComponent c = new LabeledComponent(label, this.createComponent(uris));
        c.addHeaderButton(this.newAddAction());
        c.addHeaderButton(this.newRemoveAction());
        this.add(c);
        this.setPreferredSize(new Dimension(300, 200));
    }

    private void browse() {
        JFileChooser chooser = ComponentFactory.createFileChooser(this._description, this._extension);
        chooser.setMultiSelectionEnabled(true);
        int openDialogResult = chooser.showOpenDialog(this);
        switch (openDialogResult) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                File[] files = chooser.getSelectedFiles();
                if (files == null) break;
                for (int i = 0; i < files.length; ++i) {
                    ComponentUtilities.addSelectedListValue(this._uriList, files[i].toURI());
                }
                break;
            }
            default: {
                Assert.fail("bad result: " + openDialogResult);
            }
        }
    }

    public void clearSelection() {
        this._uriList.clearSelection();
    }

    private JComponent createComponent(Collection files) {
        this._uriList = ComponentFactory.createList(this.newAddAction());
        this._uriList.addListSelectionListener(new ListSelectionListenerAdapter(this));
        if (files != null) {
            ComponentUtilities.setListValues(this._uriList, files);
        }
        return ComponentFactory.createScrollPane(this._uriList);
    }

    public Collection getURIs() {
        return ComponentUtilities.getListValues(this._uriList);
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._uriList);
    }

    private Action newAddAction() {
        return new AddAction(ResourceKey.VALUE_ADD){
            private static final long serialVersionUID = -6469490466832990499L;

            public void onAdd() {
                URIList.this.browse();
            }
        };
    }

    private Action newRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 5235237616336460573L;

            public void onRemove(Collection values) {
                ComponentUtilities.removeListValues(URIList.this._uriList, values);
            }
        };
    }
}

