/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;

public class URIUtilities {
    private static boolean isFile(URI uri) {
        return "file".equals(uri.getScheme()) || !uri.isAbsolute();
    }

    public static String getDisplayText(URI uri) {
        String text = null;
        if (uri != null) {
            if (URIUtilities.isFile(uri)) {
                File file = new File(uri.toString());
                text = file.getPath();
            } else {
                text = uri.toString();
            }
        }
        return text;
    }

    public static URI resolve(URI projectURI, String name) {
        URI uri = null;
        if (projectURI == null) {
            uri = URIUtilities.createURI(name);
        } else {
            String uriText = URIUtilities.replaceURIName(projectURI.toString(), name);
            uri = URIUtilities.createURI(uriText);
        }
        return uri;
    }

    private static String replaceURIName(String path, String newName) {
        String newPath = null;
        int index = path.lastIndexOf(47);
        if (index != -1) {
            newPath = path.substring(0, index + 1) + newName;
        }
        return newPath;
    }

    public static String getName(URI uri) {
        String path;
        String name = null;
        if (uri != null && (path = uri.getPath()) != null) {
            int index = path.lastIndexOf(47);
            name = path.substring(index + 1);
        }
        return name;
    }

    public static String getBaseName(URI uri) {
        int index;
        String baseName = URIUtilities.getName(uri);
        if (baseName != null && (index = baseName.lastIndexOf(46)) != -1) {
            baseName = baseName.substring(0, index);
        }
        return baseName;
    }

    public static URI getParentURI(URI uri) {
        String text;
        int index;
        URI parent = null;
        if (uri != null && (index = (text = uri.toString()).lastIndexOf(47)) != -1) {
            text = text.substring(0, index);
            parent = URI.create(text);
        }
        return parent;
    }

    public static String getExtension(URI uri) {
        int index;
        String extension = null;
        String name = URIUtilities.getName(uri);
        if (name != null && (index = name.lastIndexOf(46)) != -1) {
            extension = name.substring(index + 1);
        }
        return extension;
    }

    public static URL toURL(String text, URI baseURI) {
        URL url = null;
        if (text != null) {
            URI uri = null;
            try {
                uri = new URI(text);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            if (uri == null || !uri.isAbsolute()) {
                File file = new File(text);
                uri = file.isAbsolute() ? file.toURI() : URIUtilities.resolve(baseURI, text);
            }
            if (uri != null && uri.isAbsolute()) {
                try {
                    url = uri.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static URI relativize(URI baseURI, URI uriToRelativize) {
        URI relativizedURI;
        if (baseURI == null) {
            relativizedURI = uriToRelativize;
        } else {
            try {
                File file = new File(baseURI);
                if (!file.isDirectory()) {
                    File parent = file.getParentFile();
                    baseURI = parent.toURI();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            relativizedURI = baseURI.relativize(uriToRelativize);
        }
        return relativizedURI;
    }

    public static URI normalize(URI input) {
        URI uri = null;
        if (input != null && "file".equals((uri = input.normalize()).getScheme())) {
            try {
                uri = new File(uri).getCanonicalFile().toURI();
            }
            catch (IOException e) {
                uri = new File(uri).toURI();
            }
        }
        return uri;
    }

    public static URI replaceExtension(URI uri, String extension) {
        String uriString;
        int index;
        URI modifiedURI = null;
        if (uri != null && (index = (uriString = uri.toString()).lastIndexOf(46)) != -1) {
            String modifiedURIString = uriString.substring(0, index) + extension;
            modifiedURI = URIUtilities.createURI(modifiedURIString);
        }
        return modifiedURI;
    }

    public static URI ensureExtension(URI uri, String string) {
        URI goodURI = null;
        if (uri.toString().endsWith(string)) {
            goodURI = uri;
        } else {
            try {
                goodURI = new URI(uri.toString() + string);
            }
            catch (URISyntaxException e) {
                Log.getLogger().warning(e.toString());
            }
        }
        return goodURI;
    }

    public static Writer createBufferedWriter(URI uri, boolean append) {
        return FileUtilities.createBufferedWriter(new File(uri), append);
    }

    public static BufferedReader createBufferedReader(URI uri) {
        BufferedReader reader = null;
        if (uri != null) {
            try {
                File file = new File(uri);
                reader = FileUtilities.createBufferedReader(file);
            }
            catch (Exception e) {
                try {
                    URL url = uri.toURL();
                    InputStream inputStream = url.openStream();
                    reader = FileUtilities.createBufferedReader(inputStream);
                }
                catch (MalformedURLException urlException) {
                    Log.getLogger().log(Level.WARNING, "Exception caught", urlException);
                }
                catch (IOException ioException) {
                    Log.getLogger().log(Level.WARNING, "Exception caught", ioException);
                }
            }
        }
        return reader;
    }

    public static URI createURI(String s) {
        URI uri = null;
        if (s != null && (s = s.trim()).length() != 0) {
            try {
                uri = URIUtilities.hasSchemePart(s) ? new URI(s) : URIUtilities.createURIFromFileString(s);
            }
            catch (URISyntaxException e) {
                uri = URIUtilities.createURIFromFileString(s);
            }
        }
        uri = URIUtilities.normalize(uri);
        return uri;
    }

    public static boolean isURI(String s) {
        return URIUtilities.hasSchemePart(s);
    }

    private static boolean hasSchemePart(String s) {
        int index = s.indexOf(58);
        return index > 1;
    }

    private static URI createURIFromFileString(String s) {
        URI uri = null;
        try {
            uri = new File(s).toURI();
            uri = URIUtilities.normalize(uri);
        }
        catch (Exception ex) {
            Log.getLogger().severe(Log.toString(ex));
        }
        return uri;
    }

    public static boolean isValidURI(String s) {
        try {
            URI uri = new URI(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAbsoluteURI(String s) {
        try {
            URI uri = new URI(s);
            return uri.isAbsolute();
        }
        catch (Exception e) {
            return false;
        }
    }
}

