/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JTextField;

class URLPanel
extends JPanel
implements Validatable {
    private static final long serialVersionUID = -3336694646619661586L;
    private JTextField field = ComponentFactory.createTextField();

    URLPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new LabeledComponent("URL", this.field), "North");
        this.setName("URL");
    }

    public boolean validateContents() {
        boolean isValid = false;
        try {
            String text = this.field.getText();
            URL url = new URL(text);
            InputStream inputStream = url.openStream();
            inputStream.close();
            if (text.endsWith(".pprj")) {
                isValid = true;
            } else {
                ModalDialog.showMessageDialog(this, "Can only open Protege project (.pprj) files");
            }
        }
        catch (Exception e) {
            ModalDialog.showMessageDialog(this, "Unreachable URL");
        }
        return isValid;
    }

    public void saveContents() {
    }

    public URI getURI() {
        String text = this.field.getText();
        URI uri = null;
        try {
            uri = new URI(text);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }
}

