/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ValidatableTabComponent
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -630654437547399826L;
    private JTabbedPane _tabbedPane;

    public ValidatableTabComponent() {
        this.setLayout(new BorderLayout());
        this._tabbedPane = ComponentFactory.createTabbedPane(true);
        this.add(this._tabbedPane);
    }

    public void addTab(String label, Component c) {
        this._tabbedPane.addTab(label, c);
    }

    public void addTab(String label, Component c, String tooltip) {
        this._tabbedPane.addTab(label, null, c, tooltip);
    }

    public void addTab(String label, Icon icon, Component c, String tooltip) {
        this._tabbedPane.addTab(label, icon, c, tooltip);
    }

    public Component getTab(String label) {
        int indexOfTab = this._tabbedPane.indexOfTab(label);
        if (indexOfTab >= 0) {
            return this._tabbedPane.getComponent(indexOfTab);
        }
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPane;
    }

    public void saveContents() {
        int nTabs = this._tabbedPane.getTabCount();
        for (int i = 0; i < nTabs; ++i) {
            Component c = this._tabbedPane.getComponent(i);
            if (!(c instanceof Validatable)) continue;
            ((Validatable)((Object)c)).saveContents();
        }
    }

    public boolean validateContents() {
        boolean isValid = true;
        int nTabs = this._tabbedPane.getTabCount();
        for (int i = 0; i < nTabs && isValid; ++i) {
            Component c = this._tabbedPane.getComponent(i);
            if (!(c instanceof Validatable)) continue;
            isValid = ((Validatable)((Object)c)).validateContents();
        }
        return isValid;
    }
}

