/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class Wizard
extends JDialog {
    private static final long serialVersionUID = -8629186483763293509L;
    public static final int RESULT_FINISH = 1;
    public static final int RESULT_CANCEL = 2;
    private JComponent cardHolder;
    private CardLayout layout;
    private JComponent buttonPanel;
    private JButton finishButton;
    private JButton nextButton;
    private JButton backButton;
    private JButton cancelButton;
    private int result;

    protected Wizard(JComponent owner, String title) {
        super(Wizard.getFrame(owner), title, true);
        this.initialize();
    }

    protected Wizard(Dialog owner, String title) {
        super(owner, title, true);
        this.initialize();
    }

    protected void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.layout = new CardLayout();
        this.cardHolder = new JPanel(this.layout);
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.cardHolder, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.createButtons();
    }

    private static JFrame getFrame(JComponent c) {
        return (JFrame)SwingUtilities.getRoot(c);
    }

    private void createButtons() {
        this.finishButton = this.createFinishButton();
        this.nextButton = this.createNextButton();
        this.backButton = this.createBackButton();
        this.backButton.setEnabled(false);
        this.cancelButton = this.createCancelButton();
        Box holder = Box.createHorizontalBox();
        holder.add(this.backButton);
        holder.add(this.nextButton);
        holder.add(Box.createHorizontalStrut(3));
        holder.add(this.finishButton);
        holder.add(Box.createHorizontalStrut(3));
        holder.add(this.cancelButton);
        this.buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        this.buttonPanel.add(holder);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 5));
    }

    private JButton createFinishButton() {
        StandardAction action = new StandardAction("Finish"){
            private static final long serialVersionUID = -5324226196646849927L;

            public void actionPerformed(ActionEvent event) {
                Wizard.this.result = 1;
                Wizard.this.onFinish();
                Wizard.this.setVisible(false);
            }
        };
        action.setMnemonic(70);
        return this.createButton(action);
    }

    private JButton createButton(Action action) {
        JButton button = ComponentFactory.createButton(action);
        button.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                Wizard.this.updateDefaultButton();
            }

            public void focusLost(FocusEvent e) {
                Wizard.this.updateDefaultButton();
            }
        });
        return button;
    }

    private JButton createNextButton() {
        StandardAction action = new StandardAction("Next >"){
            private static final long serialVersionUID = 2762045259315677129L;

            public void actionPerformed(ActionEvent event) {
                Wizard.this.showNextPage();
            }
        };
        action.setMnemonic(78);
        return this.createButton(action);
    }

    private JButton createBackButton() {
        StandardAction action = new StandardAction("< Back"){
            private static final long serialVersionUID = 8561663556453396878L;

            public void actionPerformed(ActionEvent event) {
                Wizard.this.showPreviousPage();
            }
        };
        action.setMnemonic(66);
        return this.createButton(action);
    }

    private JButton createCancelButton() {
        AbstractAction action = new AbstractAction("Cancel"){
            private static final long serialVersionUID = -1294899151946474858L;

            public void actionPerformed(ActionEvent event) {
                Wizard.this.result = 2;
                Wizard.this.onCancel();
                Wizard.this.setVisible(false);
            }
        };
        return this.createButton(action);
    }

    private int getCurrentPageIndex() {
        int currentPageIndex = 0;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            Component c = this.cardHolder.getComponent(i);
            if (!c.isVisible()) continue;
            currentPageIndex = i;
            break;
        }
        return currentPageIndex;
    }

    private int getPageCount() {
        return this.cardHolder.getComponentCount();
    }

    public void addPage(WizardPage page) {
        if (page != null) {
            this.addPageToCardHolder(page);
            WizardPage nextPage = page.getNextPage();
            if (nextPage != null) {
                this.addPage(nextPage);
            }
        }
        this.updateButtons();
    }

    public void updateNextPage(WizardPage page) {
        if (this.removeFollowingPages(page)) {
            this.addPage(page.getNextPage());
        }
    }

    private void addPageToCardHolder(WizardPage page) {
        this.cardHolder.add((Component)page, page.getName());
    }

    private void removePageFromCardHolder(int i) {
        this.cardHolder.remove(i);
    }

    private boolean removeFollowingPages(WizardPage page) {
        int index = this.getPageIndex(page);
        if (index != -1) {
            for (int i = this.cardHolder.getComponentCount() - 1; i > index; --i) {
                this.removePageFromCardHolder(i);
            }
        }
        return index != -1;
    }

    private int getPageIndex(WizardPage page) {
        int index = -1;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            Component c = this.cardHolder.getComponent(i);
            if (c != page) continue;
            index = i;
            break;
        }
        return index;
    }

    public int execute() {
        this.layout.first(this.cardHolder);
        ComponentUtilities.center(this);
        this.setVisible(true);
        return this.result;
    }

    public void notifyChanged(WizardPage page) {
        this.updateButtons();
    }

    private void updateButtons() {
        this.backButton.setEnabled(this.canGoBack());
        this.nextButton.setEnabled(this.canGoNext());
        this.finishButton.setEnabled(this.canFinish());
        this.updateDefaultButton();
    }

    private void updateDefaultButton() {
        if (this.backButton.hasFocus()) {
            this.setDefaultButton(this.backButton);
        } else if (this.nextButton.hasFocus()) {
            this.setDefaultButton(this.nextButton);
        } else if (this.finishButton.hasFocus()) {
            this.setDefaultButton(this.finishButton);
        } else if (this.cancelButton.hasFocus()) {
            this.setDefaultButton(this.cancelButton);
        } else if (this.finishButton.isEnabled()) {
            this.setDefaultButton(this.finishButton);
        } else if (this.nextButton.isEnabled()) {
            this.setDefaultButton(this.nextButton);
        } else {
            this.setDefaultButton(null);
        }
    }

    private void setDefaultButton(JButton button) {
        this.getRootPane().setDefaultButton(button);
    }

    protected void onFinish() {
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage page = (WizardPage)this.cardHolder.getComponent(i);
            page.onFinish();
        }
    }

    protected void onCancel() {
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage page = (WizardPage)this.cardHolder.getComponent(i);
            page.onCancel();
        }
    }

    public boolean canGoBack() {
        return !this.isShowingFirstPage();
    }

    protected boolean isShowingFirstPage() {
        return this.getCurrentPageIndex() == 0;
    }

    protected boolean isShowingLastPage() {
        return this.getCurrentPageIndex() == this.getPageCount() - 1;
    }

    protected WizardPage getCurrentPage() {
        return (WizardPage)this.cardHolder.getComponent(this.getCurrentPageIndex());
    }

    public boolean canGoNext() {
        WizardPage currentPage = this.getCurrentPage();
        return currentPage.isPageComplete() && !this.isShowingLastPage();
    }

    public boolean canFinish() {
        boolean canFinish = true;
        for (int i = 0; i < this.cardHolder.getComponentCount(); ++i) {
            WizardPage page = (WizardPage)this.cardHolder.getComponent(i);
            if (page.isPageComplete()) continue;
            canFinish = false;
            break;
        }
        return canFinish;
    }

    protected void showPreviousPage() {
        this.layout.previous(this.cardHolder);
        this.getCurrentPage().requestFocus();
        this.updateButtons();
    }

    protected void showNextPage() {
        this.layout.next(this.cardHolder);
        this.getCurrentPage().requestFocus();
        this.updateButtons();
    }
}

