/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionMonitor {
    private Map<RemoteSession, Integer> transactionsInProgress = new HashMap<RemoteSession, Integer>();

    public synchronized void beginTransaction() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        int nesting = this.getNesting();
        this.transactionsInProgress.put(session, nesting + 1);
    }

    public synchronized void rollbackTransaction() {
        this.decrementTransaction();
    }

    public synchronized void commitTransaction() {
        this.decrementTransaction();
    }

    private void decrementTransaction() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        int nesting = this.getNesting();
        if (nesting <= 0) {
            Log.getLogger().warning("Exiting a transaction when no transaction is in progress");
        } else if (nesting == 1) {
            this.transactionsInProgress.remove(session);
        } else {
            this.transactionsInProgress.put(session, nesting - 1);
        }
    }

    public synchronized boolean inTransaction() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        Integer nesting = this.transactionsInProgress.get(session);
        return nesting != null;
    }

    public synchronized boolean existsTransaction() {
        return !this.transactionsInProgress.isEmpty();
    }

    public synchronized boolean exclusiveTransaction() {
        RemoteSession mySession = ServerFrameStore.getCurrentSession();
        for (RemoteSession session : this.transactionsInProgress.keySet()) {
            int nesting = this.transactionsInProgress.get(session);
            if (session.equals(mySession) && nesting <= 0) {
                return false;
            }
            if (session.equals(mySession) || nesting <= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized int getNesting() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        return this.getNesting(session);
    }

    public synchronized int getNesting(RemoteSession session) {
        Integer nesting = this.transactionsInProgress.get(session);
        if (nesting == null) {
            return 0;
        }
        return nesting;
    }

    public static boolean updatesSeenByUntransactedClients(TransactionMonitor tm) {
        return tm == null || tm.updatesSeenByUntransactedClients();
    }

    public static boolean updatesSeenByUntransactedClients(TransactionMonitor tm, TransactionIsolationLevel level) {
        return tm == null || tm.updatesSeenByUntransactedClients(level);
    }

    public boolean updatesSeenByUntransactedClients() {
        TransactionIsolationLevel level = this.getTransationIsolationLevel();
        return this.updatesSeenByUntransactedClients(level);
    }

    public boolean updatesSeenByUntransactedClients(TransactionIsolationLevel level) {
        return !this.inTransaction() || level != null && level.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0;
    }

    public synchronized Set<RemoteSession> getSessions() {
        return this.transactionsInProgress.keySet();
    }

    public abstract TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException;

    public abstract void setTransactionIsolationLevel(TransactionIsolationLevel var1) throws TransactionException;
}

