/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.impl.BasicCache;
import edu.stanford.smi.protege.util.transaction.cache.impl.CompleteableCache;
import edu.stanford.smi.protege.util.transaction.cache.impl.InvalidatableCache;
import edu.stanford.smi.protege.util.transaction.cache.impl.ReadCommittedCache;
import edu.stanford.smi.protege.util.transaction.cache.impl.ReadUncommittedCache;
import edu.stanford.smi.protege.util.transaction.cache.impl.RepeatableReadCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactory {
    public static <S, V, R> Cache<S, V, R> createEmptyCache(KnowledgeBase kb) {
        TransactionMonitor tsm = kb.getFrameStoreManager().getHeadFrameStore().getTransactionStatusMonitor();
        TransactionIsolationLevel level = tsm == null ? TransactionIsolationLevel.READ_UNCOMMITTED : tsm.getTransationIsolationLevel();
        return CacheFactory.createEmptyCache(level);
    }

    public static <S, V, R> Cache<S, V, R> createEmptyCache(TransactionIsolationLevel level) {
        CompleteableCache untransactedCache = new CompleteableCache(new BasicCache());
        if (level == TransactionIsolationLevel.NONE) {
            return new InvalidatableCache(untransactedCache, true);
        }
        if (level.compareTo(TransactionIsolationLevel.READ_UNCOMMITTED) <= 0) {
            return new InvalidatableCache(new ReadUncommittedCache(untransactedCache), true);
        }
        ReadCommittedCache readCommittedCache = new ReadCommittedCache(untransactedCache);
        if (level == TransactionIsolationLevel.READ_COMMITTED) {
            return new InvalidatableCache(readCommittedCache, false);
        }
        RepeatableReadCache repeatableReadCache = new RepeatableReadCache(readCommittedCache);
        return new InvalidatableCache(repeatableReadCache, false);
    }
}

