/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache;

import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheResult<R>
implements Serializable {
    private static final long serialVersionUID = -8134642352504821785L;
    private R result;
    private boolean isValid;

    public CacheResult(R result, boolean isValid) {
        this.result = result;
        this.isValid = isValid;
    }

    public static <R> CacheResult<R> getInvalid() {
        return new CacheResult<Object>(null, false);
    }

    public R getResult() {
        return this.result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheResult)) {
            return false;
        }
        CacheResult other = (CacheResult)obj;
        if (other.isValid() != this.isValid) {
            return false;
        }
        if (this.result == null) {
            return other.getResult() == null;
        }
        return this.result.equals(other.getResult());
    }

    public int hashCode() {
        return this.result.hashCode() + (this.isValid ? 42 : 0);
    }

    public String toString() {
        if (this.isValid()) {
            StringBuffer sb = new StringBuffer("[");
            sb.append("Valid Result ");
            if (this.getResult() == null) {
                sb.append("null");
            } else {
                sb.append(" of type ");
                sb.append(this.getResult().getClass());
                if (this.getResult() instanceof Collection) {
                    sb.append(" (size=");
                    sb.append(((Collection)this.getResult()).size());
                    sb.append(")");
                }
            }
            sb.append("]");
            return sb.toString();
        }
        return "[Invalid Result]";
    }
}

