/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCache<S, V, R>
implements Cache<S, V, R> {
    private Map<V, R> cache = new HashMap<V, R>();
    private Map<S, Integer> transactionNestingMap = new HashMap<S, Integer>();
    private static int idCounter = 0;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicCache() {
        Class<BasicCache> clazz = BasicCache.class;
        synchronized (BasicCache.class) {
            this.id = idCounter++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        return new CacheResult<R>(this.cache.get(var), this.cache.containsKey(var));
    }

    @Override
    public void updateCache(S session, V var) {
    }

    @Override
    public void updateCache(S session, V var, R value) {
        this.cache.put(var, value);
    }

    @Override
    public void modifyCache(S session, V var) {
        this.cache.remove(var);
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        this.cache.put(var, value);
    }

    @Override
    public void invalidate(S session) {
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public void startCompleteCache() {
    }

    @Override
    public void finishCompleteCache() {
    }

    @Override
    public void abortCompleteCache() {
    }

    @Override
    public boolean isCacheComplete() {
        return false;
    }

    @Override
    public void beginTransaction(S session) {
        Integer nesting = this.transactionNestingMap.get(session);
        if (nesting == null) {
            this.transactionNestingMap.put(session, 1);
            return;
        }
        this.transactionNestingMap.put(session, nesting + 1);
    }

    @Override
    public void commitTransaction(S session) {
        this.decrementTransaction(session);
    }

    @Override
    public void rollbackTransaction(S session) {
        this.decrementTransaction(session);
    }

    private void decrementTransaction(S session) {
        Integer nesting = this.transactionNestingMap.get(session);
        if (nesting == null) {
            this.transactionNestingMap.put(session, -1);
        } else if (nesting == 1) {
            this.transactionNestingMap.remove(session);
        } else {
            this.transactionNestingMap.put(session, nesting - 1);
        }
    }

    @Override
    public int getTransactionNesting(S session) {
        Integer nesting = this.transactionNestingMap.get(session);
        if (nesting == null) {
            return 0;
        }
        return nesting;
    }

    @Override
    public void flush() {
        this.transactionNestingMap.clear();
        this.cache.clear();
    }

    @Override
    public int getCacheId() {
        return this.id;
    }
}

