/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteableCache<S, V, R>
implements Cache<S, V, R> {
    private Logger logger = Log.getLogger(CompleteableCache.class);
    private CompletionStatus status = CompletionStatus.NORMAL;
    private Set<V> invalidReads = new HashSet<V>();
    private Cache<S, V, R> delegate;

    public CompleteableCache(Cache<S, V, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        CacheResult<R> result = this.delegate.readCache(session, var);
        if (result.getResult() == null && this.status == CompletionStatus.CACHE_COMPLETE && !this.invalidReads.contains(var) && !result.isValid()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " is complete - null is valid.");
            }
            return new CacheResult<Object>(null, true);
        }
        return result;
    }

    @Override
    public void updateCache(S session, V var) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.add(var);
        }
        this.delegate.updateCache(session, var);
    }

    @Override
    public void updateCache(S session, V var, R value) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.remove(var);
        }
        this.delegate.updateCache(session, var, value);
    }

    @Override
    public void modifyCache(S session, V var) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.add(var);
        }
        this.delegate.modifyCache(session, var);
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        if (this.status != CompletionStatus.NORMAL) {
            this.invalidReads.remove(var);
        }
        this.delegate.modifyCache(session, var, value);
    }

    @Override
    public void invalidate(S session) {
        this.delegate.invalidate(session);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " starting to complete the cache");
        }
        this.status = CompletionStatus.GETTING_COMPLETE_CACHE;
        this.invalidReads = new HashSet<V>();
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " cache completed");
        }
        if (this.status == CompletionStatus.GETTING_COMPLETE_CACHE) {
            this.status = CompletionStatus.CACHE_COMPLETE;
        }
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Cache " + this.getCacheId() + " caching aborted");
        }
        this.status = CompletionStatus.NORMAL;
        this.invalidReads.clear();
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.status == CompletionStatus.CACHE_COMPLETE;
    }

    @Override
    public void beginTransaction(S session) {
        this.delegate.beginTransaction(session);
    }

    @Override
    public void commitTransaction(S session) {
        this.delegate.commitTransaction(session);
    }

    @Override
    public void rollbackTransaction(S session) {
        this.delegate.rollbackTransaction(session);
    }

    @Override
    public int getTransactionNesting(S session) {
        return this.delegate.getTransactionNesting(session);
    }

    @Override
    public void flush() {
        this.localFlush();
        this.delegate.flush();
    }

    private void localFlush() {
        this.status = CompletionStatus.NORMAL;
        this.invalidReads.clear();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompletionStatus {
        NORMAL,
        GETTING_COMPLETE_CACHE,
        CACHE_COMPLETE;

    }
}

