/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidatableCache<S, V, R>
implements Cache<S, V, R> {
    private Logger logger = Log.getLogger(InvalidatableCache.class);
    private boolean ignoreTransactions;
    private Set<S> sessionsWithCacheDeleted = new HashSet<S>();
    private boolean invalid = false;
    private Cache<S, V, R> delegate;
    private int id;

    public InvalidatableCache(Cache<S, V, R> delegate, boolean ignoreTransactions) {
        this.delegate = delegate;
        this.ignoreTransactions = ignoreTransactions;
        this.id = delegate.getCacheId();
    }

    private boolean isInvalidInternal(S session) {
        return this.invalid || this.sessionsWithCacheDeleted.contains(session);
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        if (this.isInvalidInternal(session)) {
            return CacheResult.getInvalid();
        }
        return this.delegate.readCache(session, var);
    }

    @Override
    public void updateCache(S session, V var) {
        if (this.isInvalidInternal(session)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " is invalid for session " + session);
            }
            return;
        }
        this.delegate.updateCache(session, var);
    }

    @Override
    public void updateCache(S session, V var, R value) {
        if (this.isInvalidInternal(session)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Read ignored, Cache " + this.getCacheId() + " is invalid for session " + session);
            }
            return;
        }
        this.delegate.updateCache(session, var, value);
    }

    @Override
    public void modifyCache(S session, V var) {
        if (this.isInvalidInternal(session)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Read ignored, Cache " + this.getCacheId() + " is invalid for session " + session);
            }
            return;
        }
        this.delegate.modifyCache(session, var);
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        if (this.isInvalidInternal(session)) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Write ignored, Cache " + this.getCacheId() + " is invalid for session " + session);
            }
            return;
        }
        this.delegate.modifyCache(session, var, value);
    }

    @Override
    public void invalidate(S session) {
        if (this.isInvalidInternal(session)) {
            return;
        }
        if (!this.ignoreTransactions && this.delegate.getTransactionNesting(session) > 0) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " invalidated for " + session);
            }
            this.sessionsWithCacheDeleted.add(session);
        } else {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Cache " + this.getCacheId() + " invalidated");
            }
            this.die();
        }
    }

    @Override
    public boolean isInvalid() {
        return this.invalid || this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        if (this.invalid) {
            return;
        }
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        if (this.invalid) {
            return false;
        }
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S session) {
        if (this.invalid) {
            return;
        }
        this.delegate.beginTransaction(session);
    }

    @Override
    public void commitTransaction(S session) {
        if (this.invalid) {
            return;
        }
        if (this.getTransactionNesting(session) <= 0) {
            this.die();
        } else {
            this.delegate.commitTransaction(session);
            if (!this.ignoreTransactions && this.delegate.getTransactionNesting(session) == 0 && this.sessionsWithCacheDeleted.contains(session)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Commmited delete of cache " + this.getCacheId());
                }
                this.die();
            }
        }
    }

    @Override
    public void rollbackTransaction(S session) {
        if (this.invalid) {
            return;
        }
        if (this.getTransactionNesting(session) <= 0) {
            this.die();
        } else {
            this.delegate.rollbackTransaction(session);
            if (!this.ignoreTransactions && this.delegate.getTransactionNesting(session) == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Delete of cache rolled back " + this.getCacheId());
                }
                this.sessionsWithCacheDeleted.remove(session);
            }
        }
    }

    private void die() {
        this.invalid = true;
        try {
            this.delegate.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.delegate = null;
        this.sessionsWithCacheDeleted.clear();
    }

    @Override
    public int getTransactionNesting(S session) {
        if (this.isInvalidInternal(session)) {
            return 0;
        }
        return this.delegate.getTransactionNesting(session);
    }

    @Override
    public void flush() {
        if (this.invalid) {
            return;
        }
        if (!this.sessionsWithCacheDeleted.isEmpty()) {
            this.die();
        } else {
            this.delegate.flush();
        }
    }

    @Override
    public int getCacheId() {
        return this.id;
    }
}

