/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCommittedCache<S, V, R>
implements Cache<S, V, R> {
    public static final Logger LOGGER = Log.getLogger(ReadCommittedCache.class);
    private Map<S, Map<V, CacheResult<R>>> transactedWriteCache = new HashMap<S, Map<V, CacheResult<R>>>();
    private Map<S, List<CacheModify<S, V, R>>> transactedModifications = new HashMap<S, List<CacheModify<S, V, R>>>();
    private Cache<S, V, R> delegate;

    public ReadCommittedCache(Cache<S, V, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        Map<V, CacheResult<R>> valuesWrittenInTransaction = this.transactedWriteCache.get(session);
        if (valuesWrittenInTransaction != null && valuesWrittenInTransaction.containsKey(var)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Cache " + this.getCacheId() + " reading from change made in transaction for session " + session);
            }
            return valuesWrittenInTransaction.get(var);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Cache " + this.getCacheId() + " reading from cache seen by everyone  for session " + session);
        }
        return this.delegate.readCache(session, var);
    }

    @Override
    public void updateCache(S session, V var) {
        Map<V, CacheResult<R>> valuesWrittenInTransaction = this.transactedWriteCache.get(session);
        if (valuesWrittenInTransaction != null && valuesWrittenInTransaction.containsKey(var)) {
            return;
        }
        this.delegate.updateCache(session, var);
    }

    @Override
    public void updateCache(S session, V var, R value) {
        Map<V, CacheResult<R>> valuesWrittenInTransaction = this.transactedWriteCache.get(session);
        if (valuesWrittenInTransaction != null && valuesWrittenInTransaction.containsKey(var)) {
            return;
        }
        this.delegate.updateCache(session, var, value);
    }

    @Override
    public void modifyCache(S session, V var) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Modifying cache " + this.getCacheId() + " (read-committed) with unknown value");
        }
        if (this.delegate.getTransactionNesting(session) == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cache " + this.getCacheId() + " not in transaction for session " + session);
            }
            this.delegate.modifyCache(session, var);
            return;
        }
        this.addUpdateToTransaction(session, var, new CacheResult<Object>(null, false));
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Modifying cache " + this.getCacheId() + " (read-committed) with known value");
        }
        if (this.delegate.getTransactionNesting(session) == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cache " + this.getCacheId() + " not in transaction for session " + session);
            }
            this.delegate.modifyCache(session, var, value);
            return;
        }
        this.addUpdateToTransaction(session, var, new CacheResult<R>(value, true));
    }

    private void addUpdateToTransaction(S session, V var, CacheResult<R> result) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache " + this.getCacheId() + " is in transaction for session " + session);
        }
        this.transactedWriteCache.get(session).put((CacheResult<R>)var, result);
        this.transactedModifications.get(session).add(new CacheModify<S, V, R>(session, var, result));
    }

    @Override
    public void invalidate(S session) {
        this.delegate.invalidate(session);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S session) {
        if (this.getTransactionNesting(session) == 0) {
            this.transactedWriteCache.put(session, new HashMap());
            this.transactedModifications.put(session, new ArrayList());
        }
        this.delegate.beginTransaction(session);
    }

    @Override
    public void commitTransaction(S session) {
        this.delegate.commitTransaction(session);
        if (this.getTransactionNesting(session) == 0) {
            this.transactedWriteCache.remove(session);
            for (CacheModify<S, V, R> modification : this.transactedModifications.remove(session)) {
                if (modification.getNewValue().isValid()) {
                    this.delegate.modifyCache(session, modification.getVar(), modification.getNewValue().getResult());
                    continue;
                }
                this.delegate.modifyCache(session, modification.getVar());
            }
        }
    }

    @Override
    public void rollbackTransaction(S session) {
        this.delegate.rollbackTransaction(session);
        if (this.getTransactionNesting(session) == 0) {
            this.transactedWriteCache.remove(session);
            this.transactedModifications.remove(session);
        }
    }

    @Override
    public int getTransactionNesting(S session) {
        return this.delegate.getTransactionNesting(session);
    }

    @Override
    public void flush() {
        this.transactedModifications.clear();
        this.transactedWriteCache.clear();
        this.delegate.flush();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

