/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadUncommittedCache<S, V, R>
implements Cache<S, V, R> {
    private Map<S, Set<V>> transactedModifications = new HashMap<S, Set<V>>();
    private Cache<S, V, R> delegate;

    public ReadUncommittedCache(Cache<S, V, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        return this.delegate.readCache(session, var);
    }

    @Override
    public void updateCache(S session, V var) {
        this.delegate.updateCache(session, var);
    }

    @Override
    public void updateCache(S session, V var, R value) {
        this.delegate.updateCache(session, var, value);
    }

    @Override
    public void modifyCache(S session, V var) {
        if (this.delegate.getTransactionNesting(session) > 0) {
            this.transactedModifications.get(session).add(var);
        }
        this.delegate.modifyCache(session, var);
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        if (this.delegate.getTransactionNesting(session) > 0) {
            this.transactedModifications.get(session).add(var);
        }
        this.delegate.modifyCache(session, var, value);
    }

    @Override
    public void invalidate(S session) {
        this.delegate.invalidate(session);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S session) {
        if (this.delegate.getTransactionNesting(session) == 0) {
            this.transactedModifications.put(session, new HashSet());
        }
        this.delegate.beginTransaction(session);
    }

    @Override
    public void commitTransaction(S session) {
        this.delegate.commitTransaction(session);
        if (this.delegate.getTransactionNesting(session) == 0) {
            this.transactedModifications.remove(session);
        }
    }

    @Override
    public void rollbackTransaction(S session) {
        this.delegate.rollbackTransaction(session);
        for (V var : this.transactedModifications.get(session)) {
            this.delegate.modifyCache(session, var);
        }
        if (this.delegate.getTransactionNesting(session) == 0) {
            this.transactedModifications.remove(session);
        } else {
            this.transactedModifications.get(session).clear();
        }
    }

    @Override
    public int getTransactionNesting(S session) {
        return this.delegate.getTransactionNesting(session);
    }

    @Override
    public void flush() {
        this.myFlush();
        this.delegate.flush();
    }

    private void myFlush() {
        this.transactedModifications.clear();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

