/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatableReadCache<S, V, R>
implements Cache<S, V, R> {
    private Map<S, Map<V, CacheResult<R>>> repeatableReadCacheMap = new HashMap<S, Map<V, CacheResult<R>>>();
    private Cache<S, V, R> delegate;

    public RepeatableReadCache(Cache<S, V, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CacheResult<R> readCache(S session, V var) {
        Map<V, CacheResult<R>> repeatableReadCache = this.repeatableReadCacheMap.get(session);
        if (repeatableReadCache == null) {
            return this.delegate.readCache(session, var);
        }
        if (!repeatableReadCache.containsKey(var)) {
            return new CacheResult<Object>(null, false);
        }
        return repeatableReadCache.get(var);
    }

    @Override
    public void updateCache(S session, V var) {
        if (this.getTransactionNesting(session) == 0) {
            this.delegate.updateCache(session, var);
        }
    }

    @Override
    public void updateCache(S session, V var, R value) {
        Map<CacheResult<R>, CacheResult<R>> repeatableReadCache = this.repeatableReadCacheMap.get(session);
        if (repeatableReadCache != null) {
            repeatableReadCache.put((CacheResult<R>)var, new CacheResult<R>(value, true));
        } else {
            this.delegate.updateCache(session, var, value);
        }
    }

    @Override
    public void modifyCache(S session, V var) {
        Map<V, CacheResult<R>> repeatableReadCache = this.repeatableReadCacheMap.get(session);
        if (repeatableReadCache != null) {
            repeatableReadCache.remove(var);
        }
        this.delegate.modifyCache(session, var);
    }

    @Override
    public void modifyCache(S session, V var, R value) {
        Map<CacheResult<R>, CacheResult<R>> repeatableReadCache = this.repeatableReadCacheMap.get(session);
        if (repeatableReadCache != null) {
            repeatableReadCache.put((CacheResult<R>)var, new CacheResult<R>(value, true));
        }
        this.delegate.modifyCache(session, var, value);
    }

    @Override
    public void invalidate(S session) {
        this.delegate.invalidate(session);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S session) {
        if (this.getTransactionNesting(session) == 0) {
            this.repeatableReadCacheMap.put(session, new HashMap());
        }
        this.delegate.beginTransaction(session);
    }

    @Override
    public void commitTransaction(S session) {
        this.delegate.commitTransaction(session);
        this.decrementTransaction(session);
    }

    @Override
    public void rollbackTransaction(S session) {
        this.delegate.rollbackTransaction(session);
        this.decrementTransaction(session);
    }

    @Override
    public int getTransactionNesting(S session) {
        return this.delegate.getTransactionNesting(session);
    }

    @Override
    public void flush() {
        this.repeatableReadCacheMap.clear();
        this.delegate.flush();
    }

    private void decrementTransaction(S session) {
        if (this.getTransactionNesting(session) == 0) {
            this.repeatableReadCacheMap.remove(session);
        }
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

