/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.serialize;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheModify<S, V, R>
extends SerializedCacheUpdate<S, V, R> {
    private static final long serialVersionUID = -4073876220493559307L;
    private V var;
    private CacheResult<R> newValue;

    public CacheModify(S session, V var, CacheResult<R> newValue) {
        super(session);
        this.var = var;
        this.newValue = newValue;
    }

    public V getVar() {
        return this.var;
    }

    public CacheResult<R> getNewValue() {
        return this.newValue;
    }

    @Override
    public void performUpdate(Cache<S, V, R> cache) {
        if (this.newValue.isValid()) {
            cache.modifyCache(this.getSession(), this.var, this.newValue.getResult());
        } else {
            cache.modifyCache(this.getSession(), this.var);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<CacheOp: Session ");
        sb.append(this.getSession());
        sb.append(" modifies var ");
        sb.append(this.getVar());
        sb.append(" to ");
        sb.append(this.getNewValue());
        sb.append(">");
        return sb.toString();
    }
}

