/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.OwnSlotValueFrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.SwitchableListSelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class AbstractListWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = 4810580360788052158L;
    private JList _list;
    private LabeledComponent _labeledComponent;
    private SwitchableListSelectionListener _listListener = new ListSelectionListenerAdapter(this);

    protected AbstractListWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(2);
    }

    protected JList getList() {
        return this._list;
    }

    public void addButton(Action action) {
        this.addButton(action, true);
    }

    public void addButton(Action action, boolean defaultState) {
        if (action != null) {
            this.addButtonConfiguration(action, defaultState);
            if (this.displayButton(action)) {
                this._labeledComponent.addHeaderButton(action);
            }
        }
    }

    public void addItem(Object o) {
        ComponentUtilities.addListValue(this._list, o);
    }

    public void addItems(Collection items) {
        ComponentUtilities.addListValues(this._list, items);
    }

    public boolean contains(Object o) {
        return ComponentUtilities.listValuesContain(this._list, o);
    }

    private JComponent createLabeledComponent(Action action) {
        this._list = ComponentFactory.createList(action, true);
        this._list.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent event) {
                AbstractListWidget.this.valueChanged();
            }

            public void intervalAdded(ListDataEvent event) {
                AbstractListWidget.this.valueChanged();
            }

            public void intervalRemoved(ListDataEvent event) {
                AbstractListWidget.this.valueChanged();
            }
        });
        this._list.setCellRenderer(this.createRenderer());
        this._list.addListSelectionListener(this._listListener);
        this._labeledComponent = new LabeledComponent(this.getLabel(), ComponentFactory.createScrollPane(this._list));
        return this._labeledComponent;
    }

    protected ListCellRenderer createRenderer() {
        return FrameRenderer.createInstance();
    }

    protected LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._list);
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues(this._list);
    }

    public void initialize() {
        this.initialize(this.getDoubleClickAction());
        this.setEditable(true);
    }

    public void initialize(Action action) {
        this.add(this.createLabeledComponent(action));
    }

    public void removeAllItems() {
        ComponentUtilities.clearListValues(this._list);
    }

    public void removeItem(Object o) {
        if (this.isDirectValue(o)) {
            ComponentUtilities.removeListValue(this._list, o);
        } else {
            SystemUtilities.beep();
        }
    }

    public void removeItems(Collection items) {
        if (this.canRemove(items)) {
            ComponentUtilities.removeListValues(this._list, items);
        } else {
            SystemUtilities.beep();
        }
    }

    protected boolean canRemove(Collection items) {
        return this.areDirectValues(items);
    }

    public void replaceItem(Object oldItem, Object newItem) {
        ComponentUtilities.replaceListValue(this._list, oldItem, newItem);
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        for (Action action : this._labeledComponent.getHeaderButtonActions()) {
            if (!(action instanceof CreateAction) && !(action instanceof AddAction) && !(action instanceof RemoveAction) && !(action instanceof DeleteAction)) continue;
            ((AllowableAction)action).setAllowed(b);
        }
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this._list.setCellRenderer(new OwnSlotValueFrameRenderer(instance, this.getSlot()));
    }

    public void setRenderer(ListCellRenderer renderer) {
        this._list.setCellRenderer(renderer);
    }

    public void setSelection(Object o) {
        this._list.setSelectedValue(o, true);
    }

    public void setValues(Collection values) {
        ComponentUtilities.setListValues(this._list, values);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

