/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DoubleClickListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.ShowInstanceListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.AbstractWidget;
import edu.stanford.smi.protege.widget.ButtonConfigurationPanel;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public abstract class AbstractSlotWidget
extends AbstractWidget
implements SlotWidget {
    private static final long serialVersionUID = 1790525704709652862L;
    public static final String READ_ONLY_WIDGET_PROPERTY = "readOnly_configured";
    private Collection _buttonInfo;
    private Cls _cls;
    private Slot _slot;
    private Instance _instance;
    private Cls _associatedCls;
    private boolean _isBusy;
    private int _preferredColumns = 0;
    private int _preferredRows = 0;
    private static final int NORMAL_BORDER_SIZE = 5;
    private static final int SELECTED_BORDER_SIZE = 3;
    private static final Border NORMAL_BORDER;
    private DoubleClickListener _doubleClickListener;
    private ShowInstanceListener _showInstanceListener;
    private String TOOLTIP_TEXT_PROPERTY = "tooltip_text";
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (AbstractWidget.equals(event.getSlot(), AbstractSlotWidget.this.getSlot())) {
                AbstractSlotWidget.this.updateBorder(AbstractSlotWidget.this.getValues());
            }
        }
    };
    private ClsListener _associatedClsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent event) {
            if (event.isReplacementEvent()) {
                return;
            }
            if (AbstractWidget.equals(event.getFacet(), AbstractSlotWidget.this._slot.getAssociatedFacet())) {
                AbstractSlotWidget.this.loadValues();
            }
        }
    };

    protected AbstractSlotWidget() {
        this.setNormalBorder();
    }

    public void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        if (this.getAssociatedCls() != null) {
            this.getAssociatedCls().removeClsListener(this._associatedClsListener);
        }
    }

    protected Action getDoubleClickAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -1888883411836752455L;

            public void actionPerformed(ActionEvent event) {
                AbstractSlotWidget.this.handleDoubleClick();
            }
        };
    }

    public static int getSelectionBorderSize() {
        return 3;
    }

    protected void handleDoubleClick() {
        Object o = CollectionUtilities.getFirstItem(this.getSelection());
        if (o != null) {
            if (this._doubleClickListener == null) {
                this.showInstance((Instance)o);
            } else {
                this._doubleClickListener.onDoubleClick(o);
            }
        }
    }

    public void setDoubleClickListener(DoubleClickListener listener) {
        this._doubleClickListener = listener;
    }

    public void setInvalidValueBorder() {
        this.setSelectedBorder(Color.red);
    }

    public void setNormalBorder() {
        this.setBorder(NORMAL_BORDER);
    }

    public void setSelectedBorder() {
        this.setSelectedBorder(Colors.getFormColor());
    }

    public void setSelectedBorder(Color c) {
        int n = 5;
        int s = 3;
        int d = n - s;
        MatteBorder innerBandBorder = BorderFactory.createMatteBorder(s, s, s, s, c);
        Border normalBandBorder = BorderFactory.createEmptyBorder(d, d, d, d);
        CompoundBorder border = BorderFactory.createCompoundBorder(normalBandBorder, innerBandBorder);
        this.setBorder(border);
    }

    public String getDefaultToolTip() {
        return this.getPropertyList().getString(this.TOOLTIP_TEXT_PROPERTY);
    }

    public void setDefaultToolTip(String tooltip) {
        this.getPropertyList().setString(this.TOOLTIP_TEXT_PROPERTY, tooltip);
    }

    protected void updateBorder(Collection values) {
        String text = this.getDefaultToolTip();
        String invalidInstanceText = null;
        Instance instance = this.getInstance();
        if (instance != null && (invalidInstanceText = this.getKnowledgeBase().getInvalidOwnSlotValuesText(instance, this.getSlot(), values)) != null) {
            text = invalidInstanceText;
        }
        this.setToolTipText(text);
        if (invalidInstanceText == null) {
            this.setNormalBorder();
        } else {
            this.setInvalidValueBorder();
        }
        this.repaint();
    }

    public void setShowInstanceListener(ShowInstanceListener listener) {
        this._showInstanceListener = listener;
    }

    public void showInstance(Instance instance) {
        if (this._showInstanceListener == null) {
            super.showInstance(instance);
        } else {
            this._showInstanceListener.show(instance);
        }
    }

    public void addButtonConfiguration(Action action) {
        this.addButtonConfiguration(action, true);
    }

    public void addButtonConfiguration(Action action, boolean defaultState) {
        if (this._buttonInfo == null) {
            this._buttonInfo = new ArrayList();
        }
        this._buttonInfo.add(new ButtonInfo(action, defaultState));
        this.recordDefault(action, defaultState);
        String configuredDescription = this.getButtonDescription(action);
        if (configuredDescription != null) {
            action.putValue("ShortDescription", configuredDescription);
        }
    }

    public boolean allowsMultipleValues() {
        boolean result = this._associatedCls == null ? this._slot.getAllowsMultipleValues() : this._associatedCls.getTemplateSlotAllowsMultipleValues(this._slot);
        return result;
    }

    public boolean configure() {
        WidgetConfigurationPanel panel = this.createWidgetConfigurationPanel();
        int result = ModalDialog.showDialog(this, panel, "Configure " + this.getLabel(), 11, null, false);
        return result == 1;
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetPanel = new WidgetConfigurationPanel(this);
        if (this._buttonInfo != null) {
            ButtonConfigurationPanel buttonPanel = new ButtonConfigurationPanel(this.getPropertyList());
            widgetPanel.addTab("Buttons", buttonPanel);
            for (ButtonInfo info : this._buttonInfo) {
                String name = (String)info.action.getValue("Name");
                String defaultDescription = (String)info.action.getValue("ShortDescription");
                buttonPanel.addButton(name, defaultDescription, info.defaultState);
            }
        }
        return widgetPanel;
    }

    protected boolean displayButton(String propertyName) {
        Boolean b = this.getPropertyList().getBoolean(propertyName);
        return b == null ? true : b;
    }

    public boolean displayButton(Action action) {
        Boolean b = this.getPropertyList().getBoolean(AbstractSlotWidget.getDisplayPropertyName(action));
        return b == null ? true : b;
    }

    public Cls getAssociatedCls() {
        return this._associatedCls;
    }

    public String getButtonDescription(Action action) {
        return this.getPropertyList().getString(ButtonConfigurationPanel.getDescriptionPropertyName((String)action.getValue("Name")));
    }

    public Cls getCls() {
        return this._cls;
    }

    private static String getDisplayPropertyName(Action action) {
        return ButtonConfigurationPanel.getDisplayPropertyName((String)action.getValue("Name"));
    }

    public static Object getFirstItem(Collection c) {
        return CollectionUtilities.getFirstItem(c);
    }

    protected String getInvalidValueText(Collection values) {
        int count = values.size();
        int min = this.getMinimumCardinality();
        int max = this.getMaximumCardinality();
        String result = count < min ? (max == 1 ? "Value is required" : "At least " + min + " value" + (min == 1 ? " is" : "s are") + " required") : (max != -1 && count > max ? "At most " + max + " values are allowed" : null);
        return result;
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null) {
            label = this.getDefaultLabel();
        }
        return label;
    }

    protected String getDefaultLabel() {
        Slot slot = this.getSlot();
        String text = slot.getBrowserText();
        if (this.getProject().getPrettyPrintSlotWidgetLabels()) {
            text = StringUtilities.symbolToLabel(text);
        }
        return text;
    }

    protected int getMaximumCardinality() {
        return this.getCls().getTemplateSlotMaximumCardinality(this.getSlot());
    }

    protected int getMinimumCardinality() {
        return this.getCls().getTemplateSlotMinimumCardinality(this.getSlot());
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this._preferredColumns > 0) {
            d.width = this._preferredColumns * ComponentUtilities.getStandardColumnWidth();
        }
        if (this._preferredRows > 0) {
            d.height = this._preferredRows * ComponentUtilities.getStandardRowHeight();
        }
        return d;
    }

    public Slot getSlot() {
        return this._slot;
    }

    public boolean isSlotAtCls() {
        return this._associatedCls != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValues() {
        if (this.getInstance() != null && !this._isBusy) {
            this._isBusy = true;
            try {
                this.setWidgetValues();
            }
            finally {
                this._isBusy = false;
            }
        }
    }

    @Deprecated
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        if (this.isDesignTime()) {
            this.getDescriptor().setBounds(this.getBounds());
        }
    }

    private void recordDefault(Action action, boolean defaultState) {
        boolean record;
        String name = AbstractSlotWidget.getDisplayPropertyName(action);
        Boolean currentBoolean = this.getPropertyList().getBoolean(name);
        boolean bl = record = currentBoolean == null && !defaultState;
        if (record) {
            this.getPropertyList().setBoolean(name, defaultState);
        }
    }

    protected static void setAllowed(AllowableAction action, boolean state) {
        if (action != null) {
            action.setAllowed(state);
        }
    }

    public void setAssociatedCls(Cls cls) {
        if (this._associatedCls == null && cls == null || this._associatedCls != null && this._associatedCls.equals(cls)) {
            return;
        }
        if (this._associatedCls != null) {
            this._associatedCls.removeClsListener(this._associatedClsListener);
        }
        this._associatedCls = cls;
        if (this._associatedCls != null) {
            this._associatedCls.addClsListener(this._associatedClsListener);
        }
        this.loadValues();
    }

    public void setCls(Cls cls) {
        this._cls = cls;
    }

    public void setEditable(boolean b) {
    }

    public void setInstance(Instance newInstance) {
        this._instance = newInstance;
        this.loadValues();
    }

    public void setInstanceValues() {
        if (this._slot != null) {
            ArrayList newValues = new ArrayList(this.getValues());
            if (this._associatedCls == null) {
                ArrayList indirectOwnSlotValues = new ArrayList(this._instance.getOwnSlotValues(this._slot));
                List oldValues = this._instance.getDirectOwnSlotValues(this._slot);
                indirectOwnSlotValues.removeAll(oldValues);
                newValues.removeAll(indirectOwnSlotValues);
                this._instance.setDirectOwnSlotValues(this._slot, newValues);
            } else {
                Slot instanceSlot = (Slot)this._instance;
                this._associatedCls.setTemplateFacetValues(instanceSlot, this._slot.getAssociatedFacet(), newValues);
            }
            this.updateBorder(newValues);
        }
    }

    protected boolean isDirectValue(Object o) {
        boolean isDirectValue = this._associatedCls == null ? this._instance.getDirectOwnSlotValues(this._slot).contains(o) : true;
        return isDirectValue;
    }

    protected boolean areDirectValues(Collection values) {
        boolean areDirectValues;
        if (this._associatedCls == null) {
            HashSet testValues = new HashSet(values);
            testValues.removeAll(this._instance.getDirectOwnSlotValues(this._slot));
            areDirectValues = testValues.isEmpty();
        } else {
            areDirectValues = true;
        }
        return areDirectValues;
    }

    public void setPreferredColumns(int nColumns) {
        this._preferredColumns = nColumns;
    }

    public void setPreferredRows(int nRows) {
        this._preferredRows = nRows;
    }

    public void setPreferredSize(Dimension size) {
        super.setPreferredSize(size);
        this._preferredColumns = 0;
        this._preferredRows = 0;
    }

    public void setSlot(Slot slot) {
        this._slot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged() {
        if (this._instance != null && !this._isBusy) {
            this._isBusy = true;
            try {
                this.setInstanceValues();
            }
            finally {
                this._isBusy = false;
            }
        }
    }

    public void setup(WidgetDescriptor descriptor, boolean isDesignTime, Project project, Cls cls, Slot slot) {
        super.setup(descriptor, isDesignTime, project);
        this._cls = cls;
        this._slot = slot;
        this._cls.addClsListener(this._clsListener);
        Dimension d = this.getSize();
        if (d.width > 0 && d.height > 0) {
            this.setPreferredSize(d);
        }
    }

    public void setWidgetValues() {
        Collection values;
        if (this._associatedCls == null) {
            values = new ArrayList(this._instance.getOwnSlotValues(this._slot));
            boolean editable = this._instance.isEditable();
            this.setEditable(editable &= this._slot.getValueType() == ValueType.CLS || this._instance.getOwnSlotAllowsMultipleValues(this._slot) || this._instance.getDirectType().getTemplateSlotValues(this._slot).isEmpty());
        } else {
            Slot instanceSlot = (Slot)this._instance;
            Facet facet = this._slot.getAssociatedFacet();
            if (facet == null) {
                values = Collections.EMPTY_LIST;
                this.setEditable(false);
            } else {
                values = this._associatedCls.getTemplateFacetValues(instanceSlot, facet);
                boolean editable = this._associatedCls.isEditable();
                this.setEditable(editable);
            }
        }
        try {
            this.setValues(values);
            this.updateBorder(values);
        }
        catch (Exception e) {
            Log.getLogger().warning(e.toString() + " at setting the widget values for instance " + this._instance + " and " + this._slot);
            this.setValues(Collections.EMPTY_LIST);
        }
    }

    public Instance getInstance() {
        return this._instance;
    }

    public void setValues(Collection values) {
    }

    public Collection getValues() {
        return Collections.EMPTY_LIST;
    }

    public ClsWidget getClsWidget() {
        return (ClsWidget)((Object)this.getParent());
    }

    protected String localizeStandardLabel(String currentLabel, String standardCustomizedLabel, ResourceKey key) {
        if (currentLabel.equals(standardCustomizedLabel) || currentLabel.equals(this.getDefaultLabel())) {
            currentLabel = LocalizedText.getText(key);
        }
        return currentLabel;
    }

    public boolean isReadOnlyConfiguredWidget() {
        Boolean value = this.getPropertyList().getBoolean(READ_ONLY_WIDGET_PROPERTY);
        return value == null ? false : value;
    }

    public void setReadOnlyWidget(boolean isReadOnly) {
        this.getPropertyList().setBoolean(READ_ONLY_WIDGET_PROPERTY, isReadOnly);
    }

    static {
        int n = 5;
        NORMAL_BORDER = BorderFactory.createEmptyBorder(n, n, n, n);
    }

    private static class ButtonInfo {
        Action action;
        boolean defaultState;

        ButtonInfo(Action action, boolean defaultState) {
            this.action = action;
            this.defaultState = defaultState;
        }
    }
}

