/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.widget.AbstractWidget;
import edu.stanford.smi.protege.widget.TabWidget;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTabWidget
extends AbstractWidget
implements TabWidget {
    private static final long serialVersionUID = 6679591990743134105L;
    private Icon _icon;
    private String _label;
    private String _shortDescription;
    private JTree _clsTree;
    private Selectable _instanceSelectable;

    public JButton addMainWindowToolBarButton(Action action) {
        JButton button;
        JToolBar toolBar = this.getMainWindowToolBar();
        if (toolBar == null) {
            Log.getLogger().warning("Cannot find window tool bar");
            button = null;
        } else {
            button = ComponentFactory.addToolBarButton(toolBar, action);
        }
        return button;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label == null ? super.getLabel() : this._label;
    }

    public static boolean isSuitable(Project p, Collection errors) {
        return true;
    }

    public boolean canClose() {
        return true;
    }

    public boolean canSave() {
        return true;
    }

    protected JSplitPane createLeftRightSplitPane(String locationPropertyName, int defaultLocation) {
        JSplitPane pane = ComponentFactory.createLeftRightSplitPane();
        this.setSplitPane(pane, locationPropertyName, defaultLocation);
        return pane;
    }

    protected JSplitPane createTopBottomSplitPane(String locationPropertyName, int defaultLocation) {
        JSplitPane pane = ComponentFactory.createTopBottomSplitPane();
        this.setSplitPane(pane, locationPropertyName, defaultLocation);
        return pane;
    }

    public Icon getIcon() {
        return this._icon;
    }

    protected JMenuBar getMainWindowMenuBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMenuBar();
    }

    protected JToolBar getMainWindowToolBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMainToolBar();
    }

    protected JToolBar getUserToolBar(String name) {
        return ProjectManager.getProjectManager().getUserToolBar(name);
    }

    protected void addUserToolBar(JToolBar toolBar) {
        ProjectManager.getProjectManager().addUserToolBar(toolBar);
    }

    protected void removeUserToolBar(JToolBar toolBar) {
        ProjectManager.getProjectManager().removeUserToolBar(toolBar);
    }

    public void removeMainWindowToolBarButton(JButton button) {
        JToolBar toolBar = this.getMainWindowToolBar();
        if (toolBar != null) {
            toolBar.remove(button);
        }
    }

    public void save() {
    }

    public void close() {
    }

    public String getShortDescription() {
        return this._shortDescription;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    private void setSplitPane(JSplitPane pane, String name, int defaultLocation) {
    }

    public boolean configure() {
        ModalDialog.showMessageDialog(this, "No configuration options are available for this tab.");
        return true;
    }

    public void setup(WidgetDescriptor descriptor, Project project) {
        super.setup(descriptor, false, project);
    }

    public void setShortDescription(String description) {
        this._shortDescription = description;
    }

    protected void setClsTree(JTree tree) {
        this._clsTree = tree;
        this._clsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AbstractTabWidget.this.notifySelectionListeners();
            }
        });
        if (this.getProject().isMultiUserClient()) {
            this._clsTree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    final WaitCursor cursor = new WaitCursor((JTree)event.getSource());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Toolkit.getDefaultToolkit().sync();
                            cursor.hide();
                        }
                    });
                }
            });
        }
    }

    protected void setInstanceSelectable(Selectable selectable) {
        this._instanceSelectable = selectable;
        this._instanceSelectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                AbstractTabWidget.this.notifySelectionListeners();
            }
        });
    }

    public Collection getSelectedInstances() {
        return this._instanceSelectable == null ? null : this._instanceSelectable.getSelection();
    }

    public JTree getClsTree() {
        return this._clsTree;
    }

    public Collection getSelection() {
        if (this._clsTree == null) {
            return Collections.EMPTY_LIST;
        }
        TreePath path = this._clsTree.getSelectionPath();
        return path == null ? Collections.EMPTY_LIST : ComponentUtilities.getObjectPath(path);
    }

    public void synchronizeClsTree(Collection clses) {
        if (this._clsTree != null) {
            ComponentUtilities.setSelectedObjectPath(this._clsTree, clses);
        }
    }

    public void synchronizeToInstances(Collection instances) {
        if (this._instanceSelectable instanceof JList) {
            JList list = (JList)((Object)this._instanceSelectable);
            ComponentUtilities.setSelectedValues(list, instances);
        }
    }
}

