/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.TablePopupMenuMouseListener;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractTableWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -5973931887065705739L;
    private JTable _table;
    private LabeledComponent _labeledComponent;

    protected AbstractTableWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(4);
    }

    public void addButton(Action action) {
        this.addButton(action, true);
    }

    public void addButton(Action action, boolean defaultState) {
        this.addButtonConfiguration(action, defaultState);
        if (this.displayButton(action)) {
            this._labeledComponent.addHeaderButton(action);
        }
    }

    protected boolean hasButton(Icon icon) {
        return this._labeledComponent.hasHeaderButton(icon);
    }

    public void addColumn(int width, ResourceKey key, TableCellRenderer renderer) {
        TableColumn column = new TableColumn(0, width, renderer, null);
        String name = LocalizedText.getText(key);
        column.setHeaderValue(name);
        this._table.addColumn(column);
    }

    protected void configureTable(JTable table) {
        table.setModel(this.createTableModel());
        table.getSelectionModel().addListSelectionListener(new ListSelectionListenerAdapter(this));
        table.addMouseListener(new TablePopupMenuMouseListener(table){

            public JPopupMenu getPopupMenu() {
                return AbstractTableWidget.this.getPopupMenu();
            }
        });
    }

    public JComponent createMainComponent(Action action) {
        JScrollPane pane = ComponentFactory.createScrollPane(this.createTable(action));
        JViewport viewPort = pane.getViewport();
        viewPort.addMouseListener(new PopupMenuMouseListener(viewPort){

            public JPopupMenu getPopupMenu() {
                return AbstractTableWidget.this.getPopupMenu();
            }

            public void setSelection(JComponent c, int x, int y) {
            }
        });
        this._labeledComponent = new LabeledComponent(this.getLabel(), pane);
        return this._labeledComponent;
    }

    protected JTable createTable(Action action) {
        this._table = ComponentFactory.createSelectableTable(action);
        this.configureTable(this._table);
        return this._table;
    }

    public abstract TableModel createTableModel();

    public JPopupMenu getPopupMenu() {
        return null;
    }

    private static int getRow(TableModel model, Object o) {
        int row = -1;
        int nRows = model.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            if (!model.getValueAt(i, 0).equals(o)) continue;
            row = i;
            break;
        }
        return row;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._table);
    }

    private Collection getSelections() {
        TableModel model = this._table.getModel();
        ArrayList<Object> selections = new ArrayList<Object>();
        int[] rows = this._table.getSelectedRows();
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                selections.add(model.getValueAt(rows[i], 0));
            }
        }
        return selections;
    }

    public JTable getTable() {
        return this._table;
    }

    public void initialize() {
        this.initialize(null);
    }

    public void initialize(Action action) {
        this.add(this.createMainComponent(action));
        this.reload();
    }

    public void reload() {
        Collection selections = this.getSelections();
        this._table.setModel(this.createTableModel());
        this.setSelections(selections);
        this._table.revalidate();
        this._table.repaint();
        this._table.setAutoResizeMode(3);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.reload();
    }

    private void setSelections(Collection c) {
        TableModel model = this._table.getModel();
        this._table.clearSelection();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            int row = AbstractTableWidget.getRow(model, i.next());
            if (row == -1) continue;
            this._table.addRowSelectionInterval(row, row);
        }
    }
}

