/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.TreeSelectionListenerAdapter;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -1864634171376661448L;
    private JTree _tree;
    private LabeledComponent _labeledComponent;

    public AbstractTreeWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(6);
    }

    public void addButton(Action action) {
        this._labeledComponent.addHeaderButton(action);
    }

    private JComponent createMainComponent() {
        this._labeledComponent = new LabeledComponent(this.getLabel(), ComponentFactory.createScrollPane(this.createTree()));
        return this._labeledComponent;
    }

    public abstract LazyTreeRoot createRoot();

    private JComponent createTree() {
        this._tree = ComponentFactory.createTree(null);
        this._tree.addTreeSelectionListener(new TreeSelectionListenerAdapter(this));
        this._tree.addMouseListener(new TreePopupMenuMouseListener(this._tree){

            public JPopupMenu getPopupMenu() {
                return AbstractTreeWidget.this.getPopupMenu();
            }
        });
        return this._tree;
    }

    public void dispose() {
        super.dispose();
        LazyTreeModel model = (LazyTreeModel)this._tree.getModel();
        model.dispose();
    }

    public void expandAll() {
    }

    public void expandRoot() {
        TreeNode root = (TreeNode)this._tree.getModel().getRoot();
        if (root.getChildCount() == 1) {
            TreeNode child = root.getChildAt(0);
            TreePath path = new TreePath(new Object[]{root, child});
            this._tree.expandPath(path);
        }
    }

    public Object getFirstSelectionParent() {
        return ComponentUtilities.getFirstSelectionParent(this._tree);
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._tree);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void initialize() {
        this.add(this.createMainComponent());
        this.reload();
    }

    public void reload() {
        LazyTreeModel model = new LazyTreeModel(this.createRoot());
        this._tree.setModel(model);
        this._tree.setSelectionRow(0);
        this.notifySelectionListeners();
        this.expandRoot();
    }

    public static void setDisplayParent(JTree tree, Object parent) {
        ComponentUtilities.setDisplayParent(tree, parent, new SuperclassTraverser());
    }

    public static void setDisplayParent(JTree tree, Object parent, Object child) {
        ComponentUtilities.setDisplayParent(tree, parent, child, new SuperclassTraverser());
    }

    public void setFooter(JComponent c) {
        this._labeledComponent.setFooterComponent(c);
    }

    public void setHeaderComponent(JComponent c) {
        this._labeledComponent.setHeaderComponent(c);
    }

    public void setRenderer(TreeCellRenderer renderer) {
        this._tree.setCellRenderer(renderer);
    }

    public void setSelectedObjectPath(Collection objectPath) {
        ComponentUtilities.setSelectedObjectPath(this._tree, objectPath);
        this.notifySelectionListeners();
    }
}

