/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;

public abstract class AbstractWidget
extends JPanel {
    private static final long serialVersionUID = -1105419878466335322L;
    private WidgetDescriptor _descriptor;
    private boolean _isDesignTime;
    private Project _project;
    private ListenerCollection _selectionListeners = new ListenerList(new SelectionEventDispatcher());

    public AbstractWidget() {
        this.setLayout(new BorderLayout());
        this.setName(StringUtilities.getClassName(this));
    }

    public void dispose() {
    }

    public void setup(WidgetDescriptor descriptor, boolean isDesignTime, Project project) {
        this._descriptor = descriptor;
        this._isDesignTime = isDesignTime;
        this._project = project;
    }

    public WidgetDescriptor getDescriptor() {
        return this._descriptor;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public Project getProject() {
        return this._project;
    }

    public PropertyList getPropertyList() {
        return this._descriptor.getPropertyList();
    }

    public void setPropertyList(PropertyList list) {
        Assert.assertTrue("design time", this.isDesignTime());
        this._descriptor.setPropertyList(list);
    }

    public String getStringProperty(String name, String defaultString) {
        String property = this.getPropertyList().getString(name);
        if (property == null) {
            property = defaultString;
        }
        return property;
    }

    public boolean isDesignTime() {
        return this._isDesignTime;
    }

    public boolean isRuntime() {
        return !this._isDesignTime;
    }

    public void show(Cls cls, Slot slot) {
        this.getProject().show(cls, slot);
    }

    public void showInstance(Instance instance) {
        this.getProject().show(instance);
    }

    public String getLabel() {
        return this._descriptor.getLabel();
    }

    public void setLabel(String label) {
        this._descriptor.setLabel(label);
    }

    public void addSelectionListener(SelectionListener listener) {
        this._selectionListeners.add(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this._selectionListeners.remove(this, listener);
    }

    public void notifySelectionListeners() {
        this._selectionListeners.postEvent(this, 1);
    }

    public void clearSelection() {
    }

    public Collection getSelection() {
        return Collections.EMPTY_LIST;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    protected void beginTransaction(String name) {
        this.getKnowledgeBase().beginTransaction(name);
    }

    protected void beginTransaction(String name, String appliedToFrameName) {
        this.getKnowledgeBase().beginTransaction(name, appliedToFrameName);
    }

    protected void endTransaction() {
        this.getKnowledgeBase().commitTransaction();
    }

    protected void commitTransaction() {
        this.getKnowledgeBase().commitTransaction();
    }

    protected void rollbackTransaction() {
        this.getKnowledgeBase().rollbackTransaction();
    }

    public void paint(Graphics g) {
        ComponentUtilities.enableTextAntialiasing(g);
        super.paint(g);
    }
}

