/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;

public class BooleanListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = -4884073729270631387L;
    private static final Collection ALLOWED_VALUES = new ArrayList();

    private Action getCreateAction() {
        return new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -4209277615930518731L;

            public void onCreate() {
                BooleanListWidget.this.handleCreateAction();
            }
        };
    }

    private Action getEditAction() {
        return new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 8093323243741620L;

            public void onView(Object o) {
                BooleanListWidget.this.handleViewAction((Boolean)o);
            }
        };
    }

    private Action getRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 3228703105413852749L;

            public void onRemove(Collection values) {
                BooleanListWidget.this.handleRemoveAction(values);
            }
        };
    }

    protected void handleCreateAction() {
        Boolean b = this.edit("Create Boolean Value", null);
        if (b != null) {
            this.addItem(b);
        }
    }

    protected void handleRemoveAction(Collection values) {
        this.removeItems(values);
    }

    protected void handleViewAction(Boolean start) {
        Boolean end = this.edit("Edit Boolean Value", start);
        if (end != null) {
            this.replaceItem(start, end);
        }
    }

    private Boolean edit(String label, Boolean initialValue) {
        return (Boolean)DisplayUtilities.pickSymbol(this, label, initialValue, ALLOWED_VALUES);
    }

    public void initialize() {
        Action editAction = this.getEditAction();
        super.initialize(editAction);
        this.addButton(editAction);
        this.addButton(this.getCreateAction());
        this.addButton(this.getRemoveAction());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isString = cls.getTemplateSlotValueType(slot) == ValueType.BOOLEAN;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isString && isMultiple;
        }
        return isSuitable;
    }

    static {
        ALLOWED_VALUES.add(Boolean.TRUE);
        ALLOWED_VALUES.add(Boolean.FALSE);
    }
}

