/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.ButtonControlPanel;
import java.awt.Dimension;
import java.awt.GridLayout;

public class ButtonConfigurationPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = 3763344736567335495L;
    private PropertyList _propertyList;

    public ButtonConfigurationPanel(PropertyList propertyList) {
        this._propertyList = propertyList;
    }

    public void addButton(String name, String defaultDescription, boolean defaultState) {
        this.add(new ButtonControlPanel(name, defaultDescription, defaultState, this._propertyList));
        this.setLayout(new GridLayout(this.getComponentCount(), 1, 10, 10));
    }

    public static String getDescriptionPropertyName(String buttonName) {
        return "ButtonDescription-" + buttonName;
    }

    public static String getDisplayPropertyName(String buttonName) {
        return "ButtonDisplayed-" + buttonName;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Math.max(d.width, 300);
        return d;
    }

    public void saveContents() {
        int nComponents = this.getComponentCount();
        for (int i = 0; i < nComponents; ++i) {
            ButtonControlPanel panel = (ButtonControlPanel)this.getComponent(i);
            panel.saveContents();
        }
    }

    public boolean validateContents() {
        return true;
    }
}

