/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.ButtonConfigurationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ButtonControlPanel
extends JComponent {
    private static final long serialVersionUID = 5881175135211139875L;
    private String _name;
    private PropertyList _propertyList;
    private JCheckBox _enabledComponent;
    private JTextField _textComponent;

    public ButtonControlPanel(String name, String defaultDescription, boolean defaultState, PropertyList propertyList) {
        this._name = name;
        this._propertyList = propertyList;
        this._enabledComponent = ComponentFactory.createCheckBox();
        Boolean value = this._propertyList.getBoolean(this.displayStringProperty());
        this._enabledComponent.setSelected(value == null ? defaultState : value);
        this._enabledComponent.setText("Show " + name + " Button");
        this._textComponent = ComponentFactory.createTextField();
        String text = this._propertyList.getString(this.descriptionProperty());
        if (text == null) {
            text = defaultDescription;
        }
        this._textComponent.setText(text);
        this.setLayout(new BorderLayout());
        this.add((Component)this._enabledComponent, "North");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._textComponent, "North");
        this.add((Component)panel, "Center");
    }

    private String descriptionProperty() {
        return ButtonConfigurationPanel.getDescriptionPropertyName(this._name);
    }

    private String displayStringProperty() {
        return ButtonConfigurationPanel.getDisplayPropertyName(this._name);
    }

    public void saveContents() {
        boolean isEnabled = this._enabledComponent.isSelected();
        this._propertyList.setBoolean(this.displayStringProperty(), new Boolean(isEnabled));
        String text = this._textComponent.getText();
        this._propertyList.setString(this.descriptionProperty(), text);
    }
}

