/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class CheckBoxWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -2605391749596657296L;
    private JCheckBox _checkBox;

    public JCheckBox createCheckBox() {
        JCheckBox checkBox = ComponentFactory.createCheckBox();
        checkBox.setForeground(UIManager.getColor("Label.foreground"));
        return checkBox;
    }

    protected JCheckBox getCheckBox() {
        return this._checkBox;
    }

    public Collection getValues() {
        boolean checked = this._checkBox.isSelected();
        return CollectionUtilities.createCollection(checked ? Boolean.TRUE : Boolean.FALSE);
    }

    public void initialize() {
        this._checkBox = this.createCheckBox();
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CheckBoxWidget.this.valueChanged();
            }
        });
        this._checkBox.setText(this.getLabel());
        this.add(this._checkBox);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            ValueType type = cls.getTemplateSlotValueType(slot);
            boolean typeOK = type == ValueType.BOOLEAN;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = typeOK && !isMultiple;
        }
        return isSuitable;
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        this._checkBox.setEnabled(b);
    }

    public void setLabel(String text) {
        super.setLabel(text);
        this._checkBox.setText(text);
    }

    public void setValues(Collection values) {
        Boolean b = (Boolean)CollectionUtilities.getFirstItem(values);
        boolean checked = b == null ? false : b;
        this._checkBox.setSelected(checked);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

