/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JList;

public class ClsFieldWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -2832081267119267599L;
    private JList _list;
    private Instance _instance;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
        }

        public void ownSlotValueChanged(FrameEvent event) {
            ClsFieldWidget.this.repaint();
        }

        public void replaceFrame(FrameEvent event) {
            ClsFieldWidget.this.repaint();
        }
    };

    public void addButton(LabeledComponent c, Action action) {
        this.addButtonConfiguration(action);
        if (this.displayButton(action)) {
            c.addHeaderButton(action);
        }
    }

    protected void addButtons(LabeledComponent c) {
        this.addButton(c, this.getViewClsAction());
        this.addButton(c, this.getSelectClsAction());
        this.addButton(c, this.getRemoveClsAction());
    }

    public JList createList() {
        SelectableList list = ComponentFactory.createSingleItemList(this.getDoubleClickAction());
        list.setCellRenderer(FrameRenderer.createInstance());
        return list;
    }

    public void dispose() {
        super.dispose();
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
    }

    protected Action getRemoveClsAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 1835515889359535963L;

            public void onRemove(Object o) {
                ClsFieldWidget.this.handleRemoveAction();
            }
        };
        return this._removeAction;
    }

    protected Action getSelectClsAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){
            private static final long serialVersionUID = 6865317283085544137L;

            public void onAdd() {
                ClsFieldWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._instance);
    }

    public Collection getValues() {
        return CollectionUtilities.createList(this._instance);
    }

    protected Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){
            private static final long serialVersionUID = 5462508960435720753L;

            public void onView(Object o) {
                ClsFieldWidget.this.handleViewAction((Instance)o);
            }
        };
    }

    protected void handleAddAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedParents(this.getSlot());
        Cls instance = DisplayUtilities.pickCls((Component)this, this.getKnowledgeBase(), clses);
        if (instance != null) {
            this.setDisplayedInstance(instance);
        }
    }

    protected void handleRemoveAction() {
        this.removeDisplayedInstance();
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent c = new LabeledComponent(this.getLabel(), this._list);
        this.addButtons(c);
        this.add(c);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            boolean isInstance = cls.getTemplateSlotValueType(slot) == ValueType.CLS;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isInstance && !isMultiple;
        }
        return isSuitable;
    }

    protected void removeDisplayedInstance() {
        this.replaceInstance(null);
        this.updateList();
        this.valueChanged();
    }

    protected void replaceInstance(Instance instance) {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        this._instance = instance;
        if (this._instance != null) {
            this._instance.addFrameListener(this._instanceListener);
        }
        this.notifySelectionListeners();
    }

    protected void setDisplayedInstance(Instance instance) {
        this.replaceInstance(instance);
        this.updateList();
        this.valueChanged();
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        ClsFieldWidget.setAllowed(this._addAction, b);
        ClsFieldWidget.setAllowed(this._removeAction, b);
    }

    public void setValues(Collection values) {
        Instance value = (Instance)CollectionUtilities.getFirstItem(values);
        this.replaceInstance(value);
        this.updateList();
    }

    protected void updateList() {
        ComponentUtilities.setListValues(this._list, CollectionUtilities.createCollection(this._instance));
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

