/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;

public class ClsListWidget
extends AbstractListWidget {
    private static final long serialVersionUID = -1098698166996518862L;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            ClsListWidget.this.repaint();
        }

        public void replaceFrame(FrameEvent event) {
            ClsListWidget.this.repaint();
        }
    };

    protected void addButtons(LabeledComponent c, Action viewAction) {
        this.addButton(viewAction);
        this.addButton(this.getAddClsesAction());
        this.addButton(this.getRemoveClsesAction());
    }

    public void dispose() {
        super.dispose();
        this.removeListener();
    }

    protected Action getAddClsesAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){
            private static final long serialVersionUID = 727636361504600489L;

            public void onAdd() {
                ClsListWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    protected Action getRemoveClsesAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 7653766881574165449L;

            public void onRemove(Collection clses) {
                ClsListWidget.this.handleRemoveAction(clses);
            }
        };
        return this._removeAction;
    }

    protected Action getViewInstanceAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){
            private static final long serialVersionUID = 6962221637991750449L;

            public void onView(Object o) {
                ClsListWidget.this.handleViewAction((Cls)o);
            }
        };
    }

    protected void handleAddAction() {
        Collection clses = this.getCls().getTemplateSlotAllowedParents(this.getSlot());
        this.addItems(DisplayUtilities.pickClses((Component)this, this.getKnowledgeBase(), clses));
    }

    protected void handleRemoveAction(Collection clses) {
        this.removeItems(clses);
    }

    protected void handleViewAction(Cls cls) {
        this.showInstance(cls);
    }

    public void initialize() {
        super.initialize();
        this.addButtons(this.getLabeledComponent(), this.getViewInstanceAction());
        this.setRenderer(FrameRenderer.createInstance());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            Collection clses;
            ValueType type = cls.getTemplateSlotValueType(slot);
            boolean isCls = type.equals(ValueType.CLS);
            if (type.equals(ValueType.INSTANCE) && !(clses = cls.getTemplateSlotAllowedClses(slot)).isEmpty()) {
                boolean isClsMetaCls = true;
                Iterator i = clses.iterator();
                while (i.hasNext() && isClsMetaCls) {
                    Cls allowedCls = (Cls)i.next();
                    isClsMetaCls = allowedCls.isClsMetaCls();
                }
                isCls = isClsMetaCls;
            }
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = isCls && isMultiple;
        }
        return isSuitable;
    }

    protected void removeListener() {
        for (Instance instance : this.getValues()) {
            instance.removeFrameListener(this._instanceListener);
        }
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        ClsListWidget.setAllowed(this._addAction, b);
        ClsListWidget.setAllowed(this._removeAction, b);
    }

    public void setValues(Collection values) {
        this.removeListener();
        for (Instance instance : values) {
            instance.addFrameListener(this._instanceListener);
        }
        super.setValues(values);
    }
}

