/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractValuesComponent;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JScrollPane;

class ClsValuesComponent
extends AbstractValuesComponent
implements Selectable {
    private static final long serialVersionUID = -7439215898289435911L;
    private Project _project;
    private SelectableList _list;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;

    public ClsValuesComponent(Project p) {
        this._project = p;
        this._list = ComponentFactory.createSelectableList(null, true);
        this._list.setCellRenderer(FrameRenderer.createInstance());
        this._list.addListSelectionListener(new ListSelectionListenerAdapter(this));
        String text = LocalizedText.getText(ResourceKey.ALLOWED_SUPERCLASSES);
        LabeledComponent c = new LabeledComponent(text, new JScrollPane(this._list));
        c.addHeaderButton(this.getViewAction());
        c.addHeaderButton(this.getAddAction());
        c.addHeaderButton(this.getRemoveAction());
        this.add(c);
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    private Action getAddAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD){
            private static final long serialVersionUID = -8162486295759857232L;

            public void onAdd() {
                Collection clses = DisplayUtilities.pickClses((Component)ClsValuesComponent.this._list, ClsValuesComponent.this.getKnowledgeBase(), ClsValuesComponent.this.getBaseClses());
                ComponentUtilities.addUniqueListValues(ClsValuesComponent.this._list, clses);
                ClsValuesComponent.this.valueChanged();
            }
        };
        return this._addAction;
    }

    private Collection getBaseClses() {
        Collection baseClses;
        if (this.isOverride()) {
            baseClses = this.getInheritedParents();
            if (baseClses.isEmpty()) {
                baseClses = this.getKnowledgeBase().getRootClses();
            }
        } else {
            baseClses = this.getKnowledgeBase().getRootClses();
        }
        return baseClses;
    }

    private Collection getInheritedParents() {
        HashSet allowedClses = new HashSet();
        for (Cls superclass : this.getAssociatedCls().getDirectSuperclasses()) {
            allowedClses.addAll(superclass.getTemplateSlotAllowedParents(this.getSlotInstance()));
        }
        return allowedClses;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -528378262571013235L;

            public void onRemove(Collection clses) {
                ComponentUtilities.removeListValues(ClsValuesComponent.this._list, clses);
                ClsValuesComponent.this.valueChanged();
            }
        };
        return this._removeAction;
    }

    public Collection getSelection() {
        return this._list.getSelection();
    }

    public Collection getValues() {
        Collection values = ComponentUtilities.getListValues(this._list);
        return ValueTypeConstraint.getValues(ValueType.CLS, values);
    }

    private Action getViewAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){
            private static final long serialVersionUID = 7713020762470047677L;

            public void onView(Object o) {
                Cls cls = (Cls)o;
                ClsValuesComponent.this._project.show(cls);
            }
        };
    }

    public void setEditable(boolean b) {
        this._addAction.setAllowed(b);
        this._removeAction.setAllowed(b);
    }

    public void setValues(Collection values) {
        Collection allowedParents = ValueTypeConstraint.getAllowedParents(values);
        ComponentUtilities.setListValues(this._list, allowedParents);
    }
}

