/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ClsInverseRelationshipPanel;
import edu.stanford.smi.protege.ui.ClsesPanel;
import edu.stanford.smi.protege.ui.DirectInstancesList;
import edu.stanford.smi.protege.ui.DirectTypesList;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.ClsesAndInstancesTabDirectInstancesListDragSourceListener;
import edu.stanford.smi.protege.widget.InstanceClsesTreeTarget;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ClsesAndInstancesTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -918873507158261898L;
    private InstanceDisplay _instanceDisplay;
    private ClsesPanel _clsesPanel;
    private DirectInstancesList _directInstancesList;
    private DirectTypesList _directTypesList;
    private ClsInverseRelationshipPanel _inverseRelationshipPanel;
    private boolean _isUpdating;

    private JComponent createClsControlPanel() {
        JSplitPane pane = this.createTopBottomSplitPane("ClsesAndInstancesTab.left, top_bottom", 400);
        pane.setTopComponent(this.createClsesPanel());
        pane.setBottomComponent(this.createInverseRelationshipPanel());
        return pane;
    }

    private JComponent createClsesPanel() {
        this._clsesPanel = new ClsesPanel(this.getProject());
        FrameRenderer renderer = FrameRenderer.createInstance();
        renderer.setDisplayDirectInstanceCount(true);
        this._clsesPanel.setRenderer(renderer);
        this._clsesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                ClsesAndInstancesTab.this.transmitClsSelection();
            }
        });
        this._clsesPanel.getClsesTree().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ClsesAndInstancesTab.this.transmitClsSelection();
            }
        });
        return this._clsesPanel;
    }

    private JComponent createClsSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("ClsesAndInstancesTab.left_right", 250);
        pane.setLeftComponent(this.createClsControlPanel());
        pane.setRightComponent(this.createInstanceSplitter());
        return pane;
    }

    private JComponent createDirectInstancesList() {
        this._directInstancesList = new DirectInstancesList(this.getProject());
        this._directInstancesList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                if (!ClsesAndInstancesTab.this._isUpdating) {
                    ClsesAndInstancesTab.this._isUpdating = true;
                    Collection selection = ClsesAndInstancesTab.this._directInstancesList.getSelection();
                    Instance selectedInstance = selection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem(selection) : null;
                    ClsesAndInstancesTab.this._instanceDisplay.setInstance(selectedInstance);
                    ClsesAndInstancesTab.this._directTypesList.setInstance(selectedInstance);
                    ClsesAndInstancesTab.this._isUpdating = false;
                }
            }
        });
        this.setInstanceSelectable((Selectable)((Object)this._directInstancesList.getDragComponent()));
        return this._directInstancesList;
    }

    private JComponent createInstanceDisplay() {
        this._instanceDisplay = new InstanceDisplay(this.getProject());
        return this._instanceDisplay;
    }

    private JComponent createInstancesPanel() {
        JSplitPane panel = ComponentFactory.createTopBottomSplitPane();
        panel.setTopComponent(this.createDirectInstancesList());
        panel.setBottomComponent(this.createDirectTypesList());
        return panel;
    }

    protected JComponent createDirectTypesList() {
        this._directTypesList = new DirectTypesList(this.getProject());
        return this._directTypesList;
    }

    private JComponent createInstanceSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("ClsesAndInstancesTab.right.left_right", 200);
        pane.setLeftComponent(this.createInstancesPanel());
        pane.setRightComponent(this.createInstanceDisplay());
        return pane;
    }

    private JComponent createInverseRelationshipPanel() {
        this._inverseRelationshipPanel = new ClsInverseRelationshipPanel(this.getProject());
        this._inverseRelationshipPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Collection selection = ClsesAndInstancesTab.this._inverseRelationshipPanel.getSelection();
                if (selection.size() == 1) {
                    Cls cls = (Cls)selection.iterator().next();
                    ClsesAndInstancesTab.this._clsesPanel.setDisplayParent(cls);
                }
            }
        });
        return this._inverseRelationshipPanel;
    }

    public void initialize() {
        this.setIcon(Icons.getClsAndInstanceIcon());
        this.setLabel("Classes & Instances");
        this.add(this.createClsSplitter());
        this.setupDragAndDrop();
        this.transmitClsSelection();
        this.setClsTree(this._clsesPanel.getClsesTree());
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this._directInstancesList, 3, new ClsesAndInstancesTabDirectInstancesListDragSourceListener());
        new DropTarget(this._clsesPanel.getDropComponent(), 3, new InstanceClsesTreeTarget());
    }

    private void transmitClsSelection() {
        Collection selection = this._clsesPanel.getSelection();
        Instance selectedInstance = null;
        Cls selectedCls = null;
        Cls selectedParent = null;
        if (selection.size() == 1 && (selectedInstance = (Instance)CollectionUtilities.getFirstItem(selection)) instanceof Cls) {
            selectedCls = (Cls)selectedInstance;
            selectedParent = this._clsesPanel.getDisplayParent();
        }
        this._inverseRelationshipPanel.setCls(selectedCls, selectedParent);
        this._directInstancesList.setClses(selection);
        this._directInstancesList.clearSelection();
        this._instanceDisplay.setInstance(selectedCls);
    }
}

