/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsInverseRelationshipPanel;
import edu.stanford.smi.protege.ui.ClsesPanel;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ClsesTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -6113219973912500947L;
    private ClsesPanel _clsesPanel;
    private ClsInverseRelationshipPanel _inverseRelationshipPanel;
    private InstanceDisplay _instanceDisplay;

    protected JComponent createClsDisplay() {
        this._instanceDisplay = new InstanceDisplay(this.getProject());
        return this._instanceDisplay;
    }

    protected ClsesPanel createClsesPanel() {
        ClsesPanel panel = new ClsesPanel(this.getProject());
        panel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                ClsesTab.this.transmitSelection();
            }
        });
        return panel;
    }

    protected JComponent createClsesSplitter() {
        JSplitPane pane = this.createTopBottomSplitPane("ClsesTab.left.top_bottom", 400);
        this._clsesPanel = this.createClsesPanel();
        pane.setTopComponent(this._clsesPanel);
        this._inverseRelationshipPanel = this.createInverseRelationshipPanel();
        pane.setBottomComponent(this._inverseRelationshipPanel);
        return pane;
    }

    protected ClsInverseRelationshipPanel createInverseRelationshipPanel() {
        ClsInverseRelationshipPanel panel = new ClsInverseRelationshipPanel(this.getProject());
        this.initInverseRelationshipPanelListener(panel);
        return panel;
    }

    protected void initInverseRelationshipPanelListener(final ClsInverseRelationshipPanel panel) {
        panel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Collection selection = panel.getSelection();
                if (selection.size() == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem(selection);
                    ClsesTab.this._clsesPanel.setDisplayParent(cls);
                }
            }
        });
    }

    protected JComponent createMainSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("ClsesTab.left_right", 250);
        pane.setLeftComponent(this.createClsesSplitter());
        pane.setRightComponent(this.createClsDisplay());
        return pane;
    }

    public void initialize() {
        this.setIcon(Icons.getClsIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.CLASSES_VIEW_TITLE));
        this.setShortDescription("Domain Ontology");
        this.add(this.createMainSplitter());
        this.setInitialSelection();
        this.setClsTree(this._clsesPanel.getClsesTree());
    }

    public LabeledComponent getLabeledComponent() {
        return this._clsesPanel.getLabeledComponent();
    }

    public void setFinderComponent(JComponent c) {
        this._clsesPanel.setFinderComponent(c);
    }

    private void setInitialSelection() {
        if (this._clsesPanel != null) {
            this.transmitSelection();
        }
    }

    protected void transmitSelection() {
        Collection selection = this._clsesPanel.getSelection();
        Instance selectedInstance = null;
        Cls selectedCls = null;
        Cls selectedParent = null;
        if (selection.size() == 1 && (selectedInstance = (Instance)CollectionUtilities.getFirstItem(selection)) instanceof Cls) {
            selectedCls = (Cls)selectedInstance;
            selectedParent = this._clsesPanel.getDisplayParent();
        }
        this._inverseRelationshipPanel.setCls(selectedCls, selectedParent);
        this._instanceDisplay.setInstance(selectedInstance);
    }
}

