/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public class ComboBoxWidget
extends AbstractSlotWidget {
    private static final long serialVersionUID = -1649506562178607049L;
    protected static final String NONE = "";
    private JComboBox _comboBox;
    private boolean _displayNullEntry = true;
    private ActionListener _listener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            ComboBoxWidget.this.comboBoxValueChanged();
        }
    };

    protected void comboBoxValueChanged() {
        this.valueChanged();
    }

    public JComboBox createComboBox() {
        return ComponentFactory.createComboBox();
    }

    public ComboBoxModel createModel() {
        DefaultComboBoxModel<Object> model;
        Slot slot = this.getSlot();
        if (slot == null) {
            Log.getLogger().warning("No slot");
            model = new DefaultComboBoxModel();
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            ValueType type = this.getCls().getTemplateSlotValueType(slot);
            if (type == ValueType.BOOLEAN) {
                values.add(Boolean.TRUE);
                values.add(Boolean.FALSE);
            } else if (type == ValueType.SYMBOL) {
                values.addAll(this.getCls().getTemplateSlotAllowedValues(slot));
            } else {
                Assert.fail("bad type");
            }
            if (this._displayNullEntry) {
                values.add(0, NONE);
            }
            model = new DefaultComboBoxModel<Object>(values.toArray());
        }
        return model;
    }

    public JComboBox getComboBox() {
        return this._comboBox;
    }

    public Object getComboBoxSelection() {
        return this._comboBox.getSelectedItem();
    }

    public boolean getDisplayNullEntry() {
        return this._displayNullEntry;
    }

    public Collection getValues() {
        Object value = this._comboBox.getSelectedItem();
        if (value == NONE) {
            value = null;
        }
        return CollectionUtilities.createList(value);
    }

    public void initialize() {
        this._comboBox = this.createComboBox();
        this.setComboBoxModel(this.createModel());
        this.add(new LabeledComponent(this.getLabel(), this._comboBox));
        this.setPreferredColumns(1);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean isSuitable;
        if (cls == null || slot == null) {
            isSuitable = false;
        } else {
            ValueType type = cls.getTemplateSlotValueType(slot);
            boolean typeOK = type == ValueType.SYMBOL || type == ValueType.BOOLEAN;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            isSuitable = typeOK && !isMultiple;
        }
        return isSuitable;
    }

    public void setComboBoxModel(ComboBoxModel model) {
        this._comboBox.removeActionListener(this._listener);
        this._comboBox.setModel(model);
        this._comboBox.addActionListener(this._listener);
    }

    protected void setComboBoxValue(String value) {
        this._comboBox.removeActionListener(this._listener);
        this._comboBox.setSelectedItem(value);
        this._comboBox.addActionListener(this._listener);
    }

    public void setDisplayNullEntry(boolean b) {
        this._displayNullEntry = b;
    }

    public void setEditable(boolean b) {
        b = b && !this.isReadOnlyConfiguredWidget();
        this._comboBox.setEnabled(b);
    }

    public void setLabel(String text) {
        super.setLabel(text);
        LabeledComponent c = (LabeledComponent)this.getComponent(0);
        c.setHeaderLabel(text);
    }

    public void setRenderer(ListCellRenderer renderer) {
        this._comboBox.setRenderer(renderer);
    }

    public void setValues(Collection values) {
        Object value = CollectionUtilities.getFirstItem(values);
        this._comboBox.setSelectedItem(value);
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel confPanel = super.createWidgetConfigurationPanel();
        confPanel.addTab("Options", new ReadOnlyWidgetConfigurationPanel(this));
        return confPanel;
    }
}

