/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.SlotWidgetComparer;
import edu.stanford.smi.protege.widget.WidgetLayoutStrategy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class DefaultWidgetLayoutStrategy
implements WidgetLayoutStrategy {
    private static final int COLUMN_WIDTH = 250;
    private static final int MAX_COLUMNS = 3;

    private boolean canStretchVertically(Component c) {
        return c.getPreferredSize().height > ComponentUtilities.getStandardRowHeight();
    }

    private void doOneColumnLayout(List components) {
        Collections.sort(components, new SlotWidgetComparer());
        Point p = new Point();
        Dimension previousComponentSize = new Dimension();
        for (Component c : components) {
            Dimension currentComponentSize = c.getPreferredSize();
            if (currentComponentSize.width + p.x > 250) {
                p.x = 0;
                p.y += previousComponentSize.height;
            }
            c.setBounds(new Rectangle(p, c.getPreferredSize()));
            p.x += currentComponentSize.width;
            previousComponentSize = currentComponentSize;
        }
    }

    private void doThreeColumnLayout(List components) {
        this.doNColumnLayout(3, components);
    }

    private void doTwoColumnLayout(List components) {
        this.doNColumnLayout(2, components);
    }

    private void doNColumnLayout(int n, List components) {
        if (!components.isEmpty()) {
            this.doOneColumnLayout(components);
            JComponent lastComponent = (JComponent)components.get(components.size() - 1);
            Rectangle bounds = lastComponent.getBounds();
            int columnHeight = (bounds.y + bounds.height) / n;
            int currentYShift = 0;
            int currentColumn = 0;
            int currentXShift = 0;
            int widestPoint = 0;
            Component[] bottomComponents = new Component[n];
            for (Component c : components) {
                int column = c.getY() / columnHeight;
                if (column != currentColumn) {
                    currentColumn = column;
                    currentYShift = c.getY();
                    currentXShift = widestPoint;
                }
                Point newLocation = new Point(c.getX() + currentXShift, c.getY() - currentYShift);
                widestPoint = Math.max(widestPoint, newLocation.x + c.getWidth());
                c.setLocation(newLocation);
                bottomComponents[column] = c;
            }
            this.evenBottomComponents(bottomComponents);
        }
    }

    private void evenBottomComponents(Component[] components) {
        Component c;
        int i;
        int max = 0;
        for (i = 0; i < components.length; ++i) {
            c = components[i];
            if (c == null) continue;
            max = Math.max(max, c.getY() + c.getHeight());
        }
        for (i = 0; i < components.length; ++i) {
            c = components[i];
            if (c == null || !this.canStretchVertically(c)) continue;
            Dimension size = new Dimension(c.getWidth(), max - c.getY());
            c.setSize(size);
        }
    }

    private int getPreferredNumberOfColumns(List components) {
        int maxWidth = 0;
        int totalHeight = 0;
        for (Component c : components) {
            Dimension d = c.getPreferredSize();
            maxWidth = Math.max(maxWidth, d.width);
            totalHeight += d.height;
        }
        int nColumns = (totalHeight + 250 - 1) / 250;
        nColumns = Math.max(nColumns, (maxWidth - 1) / 250 + 1);
        nColumns = Math.min(3, nColumns);
        return nColumns;
    }

    public void layout(Container container, int index) {
        ArrayList<Component> allComponents = new ArrayList<Component>(Arrays.asList(container.getComponents()));
        List moveableComponents = allComponents.subList(index, allComponents.size());
        int nColumns = this.getPreferredNumberOfColumns(moveableComponents);
        switch (nColumns) {
            case 1: {
                this.doOneColumnLayout(moveableComponents);
                break;
            }
            case 2: {
                this.doTwoColumnLayout(moveableComponents);
                break;
            }
            default: {
                this.doThreeColumnLayout(moveableComponents);
            }
        }
        this.shiftMovableComponents(allComponents, index);
    }

    private void shiftMovableComponents(List allComponents, int index) {
        Component c;
        int i;
        int height = 0;
        int nComponents = allComponents.size();
        if (index < nComponents) {
            for (i = 0; i < index; ++i) {
                c = (Component)allComponents.get(i);
                Rectangle r = c.getBounds();
                height = Math.max(height, r.y + r.height);
            }
        }
        if (height > 0) {
            for (i = index; i < nComponents; ++i) {
                c = (Component)allComponents.get(i);
                Point p = c.getLocation();
                p.y += height;
                c.setLocation(p);
            }
        }
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

