/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.WidgetMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWidgetMapper
implements WidgetMapper {
    private Logger log = Log.getLogger(DefaultWidgetMapper.class);
    private static final String METHOD_NAME = "isSuitable";
    private static final Class[] METHOD_ARG_CLASSES = new Class[]{Cls.class, Slot.class, Facet.class};
    private KnowledgeBase _knowledgeBase;

    public DefaultWidgetMapper(KnowledgeBase kb) {
        this._knowledgeBase = kb;
    }

    public WidgetDescriptor createWidgetDescriptor(Cls cls, Slot slot, Facet facet) {
        WidgetDescriptor d = WidgetDescriptor.create(this._knowledgeBase);
        String className = this.getDefaultWidgetClassName(cls, slot, facet);
        d.setWidgetClassName(className);
        d.setName(slot.getName());
        return d;
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        String className;
        Collection allowedClses;
        boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
        ValueType type = cls.getTemplateSlotValueType(slot);
        Cls allowedCls = null;
        if (type == ValueType.INSTANCE && (allowedClses = cls.getTemplateSlotAllowedClses(slot)).size() == 1) {
            allowedCls = (Cls)CollectionUtilities.getFirstItem(allowedClses);
        }
        if ((className = PluginUtilities.getDefaultWidgetClassName(isMultiple, type, allowedCls, slot)) != null && !this.isSuitable(cls, slot, facet, className)) {
            className = PluginUtilities.getDefaultWidgetClassName(isMultiple, type, allowedCls);
        }
        return className;
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        ArrayList<String> suitableWidgetClassNames = new ArrayList<String>();
        for (String className : PluginUtilities.getAvailableSlotWidgetClassNames()) {
            if (!this.isSuitable(cls, slot, facet, className)) continue;
            suitableWidgetClassNames.add(className);
        }
        return suitableWidgetClassNames;
    }

    public boolean isSuitable(Cls cls, Slot slot, Facet facet, String className) {
        boolean isSuitable;
        try {
            Class widgetClass = SystemUtilities.forName(className);
            if (widgetClass == null) {
                isSuitable = false;
                Log.getLogger().warning("Invalid widget class name: " + className);
            } else {
                Method method = widgetClass.getMethod(METHOD_NAME, METHOD_ARG_CLASSES);
                Boolean result = (Boolean)method.invoke(null, cls, slot, facet);
                isSuitable = result;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could not verify isSuitable for widget: " + className + " class: " + cls + " slot: " + slot, e);
            isSuitable = false;
        }
        return isSuitable;
    }

    public boolean isSuitableWidget(Cls cls, Slot slot, Facet facet, WidgetDescriptor d) {
        return this.isSuitable(cls, slot, facet, d.getWidgetClassName());
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

