/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.widget.ClsListWidget;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class DirectDomainWidget
extends ClsListWidget {
    private static final long serialVersionUID = 3076537248100213883L;

    public void initialize() {
        super.initialize();
    }

    protected void handleAddAction() {
        Collection clses = this.getAllowedParents();
        Collection selectedClses = DisplayUtilities.pickClses((Component)this, this.getKnowledgeBase(), clses);
        HashSet classSet = new HashSet(selectedClses);
        classSet.removeAll(this.getValues());
        this.addItems(classSet);
    }

    protected boolean canRemove(Collection values) {
        return true;
    }

    private Collection getAllowedParents() {
        Collection<Cls> domain = new ArrayList<Cls>();
        Slot slot = (Slot)this.getInstance();
        for (Slot superslot : slot.getSuperslots()) {
            Collection superslotDomain = superslot.getDirectDomain();
            domain = this.resolveValues(domain, superslotDomain);
        }
        if (domain.isEmpty()) {
            domain.add(this.getKnowledgeBase().getRootCls());
        }
        return domain;
    }

    private Collection resolveValues(Collection existingDomain, Collection superslotDomain) {
        return existingDomain.isEmpty() ? superslotDomain : existingDomain;
    }

    public void setValues(Collection values) {
        Slot slot = (Slot)this.getInstance();
        Collection domain = new ArrayList(slot.getDirectDomain());
        if (domain.isEmpty()) {
            for (Slot superslot : slot.getSuperslots()) {
                Collection superslotDomain = superslot.getDirectDomain();
                domain = this.resolveValues(domain, superslotDomain);
            }
        }
        super.setValues(domain);
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Domain", ResourceKey.DOMAIN_SLOT_WIDGET_LABEL);
    }
}

