/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.widget.NumberFieldWidget;
import java.util.ArrayList;
import java.util.Collection;

public class FloatFieldWidget
extends NumberFieldWidget {
    private static final long serialVersionUID = -2408555647675847253L;

    protected String getInvalidTextDescription(String text) {
        String result = null;
        try {
            Number max;
            float f = Float.parseFloat(text);
            Number min = this.getCls().getTemplateSlotMinimumValue(this.getSlot());
            if (min != null && f < min.floatValue()) {
                result = "The minimum value is " + min;
            }
            if ((max = this.getCls().getTemplateSlotMaximumValue(this.getSlot())) != null && f > max.floatValue()) {
                result = "The maximum value is " + max;
            }
        }
        catch (NumberFormatException e) {
            result = "The value must be a number";
        }
        return result;
    }

    public Collection getValues() {
        ArrayList<Float> values = new ArrayList<Float>();
        String text = this.getText();
        try {
            if (text != null) {
                values.add(new Float(text));
            }
        }
        catch (NumberFormatException e) {
            this.setText(null);
        }
        return values;
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean result = false;
        if (cls != null && slot != null) {
            boolean isFloat = cls.getTemplateSlotValueType(slot) == ValueType.FLOAT;
            boolean isMultiple = cls.getTemplateSlotAllowsMultipleValues(slot);
            result = isFloat && !isMultiple;
        }
        return result;
    }
}

